#!/usr/local/bin/perl
# 
# $Header: emas/sysman/admin/scripts/iam/getDSEEResponse.pl /main/6 2012/04/15 03:56:09 rahgupta Exp $
#
# getDSEEResponse.pl
# 
# Copyright (c) 2010, 2012, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      getDSEEResponse.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    kchander    03/21/12 - XbranchMerge kchander_bug-13797790 from
#                           st_emgc_12.1.0.1bp12.1.0.2pg
#    kchander    03/01/12 - Fix bug 13799129.
#    kchander    04/21/11 - Fix bug 12384137.
#    kchander    03/01/11 - Fix solaris issues.
#    rayleung    01/06/11 - Bug 10366685
#    kchander    12/08/10 - ssl .
#    kchander    11/23/10 - fix backendfiles.
#    kchander    11/18/10 - fix bugs.
#    kchander    08/24/10 - Fix replication issue.
#    kchander    06/15/10 - Creation
# 

require "emd_common.pl";
use Net::LDAP;
use LWP::Simple;
use LWP::UserAgent;
use HTTP::Request;
use ParseStdin;
use HTTP::Date;
use Time::Local;
use IPC::Open2;

my $host=$ARGV[0];
my $port=$ARGV[1];
my $MetricName = $ARGV[2];
my $IPath = $ARGV[3];

if ($MetricName eq "DSEEServerResourceUsage")
{

  my ($mem, $cpu, $memCpu);
  if (($^O =~ "Windows") || ($^O =~ "MSWin32")) {
    ($mem, $cpu, $status) = getResourceNT();
  }
  else {

      #$ENV{PATH} = "/usr/bin:/usr/sbin:/usr/local/bin:/local/bin";
   ($mem, $cpu, $memCpu) = getResource($IPath);
  }
  print "em_result=$mem|$cpu|$memCpu\n";
  #print "em_result=1|1|1\n";
  exit;

}


ParseStdin::initStdin();
my $username = ParseStdin::getParameter("UserName");
my $passwd = ParseStdin::getParameter("PASSWORD");



if ($MetricName eq "ENTResponse")
{

    open (MYFILE, '>testfile');
    print MYFILE "$passwd\n";
    close (MYFILE); 


    my $installHome = $ARGV[3];
    $cmd = "\"".$installHome."/bin/dsccmon\"  view-servers -h ".$host." -p ".$port." -D \"".$username."\" -w testfile" ;
    my($OUT,$IN);
    my $pid = open2($OUT,$IN, $cmd);

    close($IN);

    my @results ;
    my $res;
    my $line;
    while($line = <$OUT>)
    {
      chomp($line);
      push(@results, $line);    
    }

    close($OUT);
    waitpid($pid, 0);
    $i=0;
    foreach $line (@results)
    {
        if ($i >1 )
        {
            @words = split(/ +/, $line);
            $res = $res.$words[1];
        }
        $i++;
    }
    
    if ($res =~ m/OK/)
    {
        print ("em_result=1|$res");
    }
    else
    {
        print ("em_result=0|$res");
    }

    unlink("testfile");
    exit ;
}

if ($MetricName eq "ENTReplication")
{

    open (MYFILE, '>testfile');
    print MYFILE "$passwd\n";
    close (MYFILE); 


    my $installHome = $ARGV[3];
    $cmd = "\"".$installHome."/bin/dsccmon\"  view-suffixes -b -h ".$host." -p ".$port." -D \"".$username."\" -w testfile" ;
    my($OUT,$IN);
    my $pid = open2($OUT,$IN, $cmd);

    close($IN);

    my @results ;
    my $res;
    my $line;
    while($line = <$OUT>)
    {
      chomp($line);
      push(@results, $line);    
    }

    close($OUT);
    waitpid($pid, 0);
    foreach $line (@results)
    {
        chomp($line);
        next unless($line =~ /\W+/);
        @words = split(/ +/, $line);
        $res = $res.$words[1];
	# NMC - Bug 10366685	
        if ($words[6] eq "-" || $words[6] eq "") 
	{ 
	    $words[6] = 0; 
	}
	# AMC - Bug 10366685
	if ($words[7] eq "-" || $words[7] eq "") 
	{
            $words[7] = 0;
        }

        print ("em_result=".$words[1]."|".$words[2]."|".$words[0]."|".$words[3]."|".$words[4]."|".$words[5]."|".$words[6]."|".$words[7]."|".$words[8]."\n");
    }
    

    unlink("testfile");
    exit ;
}



my $ldap = Net::LDAP->new($host,port=>$port);

if ( not $ldap ) {
    $errtxt = "Could not connect to ldap server, please check machine name and port number";
    $status = 0;
    print ("em_result=0|$errtxt\n");
    #exit 0;
    exit ;
}

if ($MetricName eq "Response")
{
    $bindmesg = $ldap->bind($username,password=>$passwd);
    $bindCode = $bindmesg->code();
    #print "The bindCode is $bindCode\n $username--$passwd\n";
    if ($bindCode != 0) {
        $errtxt = $bindmesg->error_text();
        #print "$errtxt\n";
        $status = 0;
        print ("em_result=0\n");
        exit;
    }
    else
    {
        #print "em_result=1|\n";
        print "em_result=1|$bindCode\n";
    }
    $ldap->unbind;
}
elsif ($MetricName eq "Version")
{
    $ldap->bind($username,password=>$passwd);
    $mesg = $ldap->search(filter=>"(objectclass=*)",base=>"cn=monitor");
    @entries = $mesg->entries;
    $count = $mesg->count;
    $entry = $mesg->entry(0);
    my $entver = $entry->get_value("version");
    @tmp = split(/\//, $entver);
    @ver = split(/ /, $tmp[1]);
    #$entver = $ver[0];
    print "em_result=$ver[0]\n";
    $ldap->unbind;
}
elsif ($MetricName eq "GeneralInfo")
{
    $ldap->bind($username,password=>$passwd);
    $mesg = $ldap->search(filter=>"(objectclass=*)",base=>"cn=Monitor");
    @entries = $mesg->entries;
    $count = $mesg->count;
    $entry = $mesg->entry(0);
    @attrs = $entry->attributes();
    $t = "";
    @reqattrs = ("version","currenttime","starttime","nbackends");
    foreach $rattr (@reqattrs)
    {
        $t = $t.$entry->get_value($rattr)."|";
    }
    $ldap->unbind;
    print "em_result=$t\n";

}
elsif ($MetricName eq "Connections")
{
    $ldap->bind($username,password=>$passwd);
    $mesg = $ldap->search(filter=>"(objectclass=*)",base=>"cn=Monitor");
    @entries = $mesg->entries;
    $count = $mesg->count;
    $entry = $mesg->entry(0);
    @attrs = $entry->attributes();
    $t = "";
    @reqattrs = ("connectionpeak","currentconnections","totalconnections");
    foreach $rattr (@reqattrs)
    {
        $t = $t.$entry->get_value($rattr)."|";
    }
    $srtime = $entry->get_value("starttime");
    $stime1 = getTime($srtime);
    $srtime = $entry->get_value("currenttime");
    $ctime = getTime($srtime);
    $totc = $entry->get_value("totalconnections");
    $totcps = $totc/(($ctime-$stime1));
    
    $t = $t.$totcps;
    
    
    $ldap->unbind;
    print "em_result=$t\n";

}
elsif ($MetricName eq "Queues")
{
    $ldap->bind($username,password=>$passwd);
    $mesg = $ldap->search(filter=>"(objectclass=*)",base=>"cn=Monitor");
    @entries = $mesg->entries;
    $count = $mesg->count;
    $entry = $mesg->entry(0);
    @attrs = $entry->attributes();
    $t = "";
    @reqattrs = ("readwaiters","request-que-backlog");
    foreach $rattr (@reqattrs)
    {
        $t = $t.$entry->get_value($rattr)."|";
    }
    $opsinit = $entry->get_value("opsinitiated");
    $opscomp = $entry->get_value("opscompleted");
    $t = $t. ($opsinit-$opscomp);
    
    $ldap->unbind;
    print "em_result=$t\n";

}
elsif ($MetricName eq "Operations")
{
    $ldap->bind($username,password=>$passwd);
    $mesg = $ldap->search(filter=>"(objectclass=*)",base=>"cn=Monitor");
    @entries = $mesg->entries;
    $count = $mesg->count;
    $entry = $mesg->entry(0);
    @attrs = $entry->attributes();
    $t = "";
    @reqattrs = ("opsinitiated","opscompleted");
    foreach $rattr (@reqattrs)
    {
        $t = $t.$entry->get_value($rattr)."|";
    }

    $srtime = $entry->get_value("starttime");
    $stime1 = getTime($srtime);
    $srtime = $entry->get_value("currenttime");
    $ctime = getTime($srtime);
    $totopsc = $entry->get_value("opsinitiated");
    $totopscpersec = $totopsc/(($ctime-$stime1));
    $t = $t.$totopscpersec."|";
    $totopsc = $entry->get_value("opscompleted");
    $totopscpersec = $totopsc/(($ctime-$stime1));
    $t = $t.$totopscpersec."|";
    $totops = 0;
    $entry = $mesg->entry(4);

    @reqattrs = ("unauthbinds","simpleauthbinds","strongauthbinds","compareops","searchops","onelevelsearchops","wholesubtreesearchops","addentryops","removeentryops","modifyentryops","modifyrdnops");
    foreach $rattr (@reqattrs)
    {
        $totops = $totops+$entry->get_value($rattr);
    }
    $t = $t.$totops."|".$totops/($ctime-$stime1)."|";
    
    
    #Compute Etime
    $entry = $mesg->entry(1);

    @reqattrs = ("bindetimesum", "searchetimesum","modifyetimesum","addetimesum","deleteetimesum","modrdnetimesum","compareetimesum");
    $etimesum =0;
    foreach $rattr (@reqattrs)
    {
            $etimesum = $etimesum + ($entry->get_value($rattr)*1000);
    }
    $t = $t.$etimesum."|";

    $t = $t.($etimesum/$totops);
    
    $ldap->unbind;
    print "em_result=$t\n";

}
elsif ($MetricName eq "ReadOperations")
{
    $ldap->bind($username,password=>$passwd);
    $mesg = $ldap->search(filter=>"(objectclass=*)",base=>"cn=Monitor");
    @entries = $mesg->entries;
    $count = $mesg->count;
    $entry = $mesg->entry(0);
    $srtime = $entry->get_value("starttime");
    $stime1 = getTime($srtime);
    $srtime = $entry->get_value("currenttime");
    $ctime = getTime($srtime);
    $entry = $mesg->entry(4);
    @attrs = $entry->attributes();
    $t = "";
    @reqattrs = ("anonymousbinds","unauthbinds","simpleauthbinds","strongauthbinds");
    $binds=0;
    foreach $rattr (@reqattrs)
    {
        $t = $t.$entry->get_value($rattr)."|".($entry->get_value($rattr)/($ctime-$stime1))."|";
    }
    $binds = $entry->get_value("unauthbinds") + $entry->get_value("simpleauthbinds") + $entry->get_value("strongauthbinds");

    $t = $t.$binds."|".$binds/($ctime-$stime1);
    $ldap->unbind;
    
    print "em_result=$t\n";
}
elsif ($MetricName eq "CompareOperations")
{
    $ldap->bind($username,password=>$passwd);
    $mesg = $ldap->search(filter=>"(objectclass=*)",base=>"cn=Monitor");
    @entries = $mesg->entries;
    $count = $mesg->count;
    $entry = $mesg->entry(0);
    $srtime = $entry->get_value("starttime");
    $stime1 = getTime($srtime);
    $srtime = $entry->get_value("currenttime");
    $ctime = getTime($srtime);
    $entry = $mesg->entry(4);
    @attrs = $entry->attributes();
    $t = "";
    @reqattrs = ("compareops");
    foreach $rattr (@reqattrs)
    {
        $t = $t.$entry->get_value($rattr)."|".($entry->get_value($rattr)/($ctime-$stime1))."|";
    }

    $ldap->unbind;
    print "em_result=$t\n";
}
elsif ($MetricName eq "SearchOperations")
{
    $ldap->bind($username,password=>$passwd);
    $mesg = $ldap->search(filter=>"(objectclass=*)",base=>"cn=Monitor");
    @entries = $mesg->entries;
    $count = $mesg->count;
    $entry = $mesg->entry(0);
    $srtime = $entry->get_value("starttime");
    $stime1 = getTime($srtime);
    $srtime = $entry->get_value("currenttime");
    $ctime = getTime($srtime);
    $entry = $mesg->entry(4);
    @attrs = $entry->attributes();
    $t = "";
    @reqattrs = ("searchops","onelevelsearchops","wholesubtreesearchops");
    $srchops = 0;
    foreach $rattr (@reqattrs)
    {
        $t = $t.$entry->get_value($rattr)."|".($entry->get_value($rattr)/($ctime-$stime1))."|";
        $srchops = $srchops + $entry->get_value($rattr);
    }

    $t = $t.$entry->get_value("bytessent")."|".($entry->get_value("bytessent")/($ctime-$stime1))."|";
    $t = $t.$srchops."|".$srchops/($ctime-$stime1);
    $ldap->unbind;
    print "em_result=$t\n";
}
elsif ($MetricName eq "WriteOperations")
{
    $ldap->bind($username,password=>$passwd);
    $mesg = $ldap->search(filter=>"(objectclass=*)",base=>"cn=Monitor");
    @entries = $mesg->entries;
    $count = $mesg->count;
    $entry = $mesg->entry(0);
    $srtime = $entry->get_value("starttime");
    $stime1 = getTime($srtime);
    $srtime = $entry->get_value("currenttime");
    $ctime = getTime($srtime);
    $entry = $mesg->entry(4);
    @attrs = $entry->attributes();
    $t = "";
    @reqattrs = ("addentryops","removeentryops","modifyentryops","modifyrdnops");
    foreach $rattr (@reqattrs)
    {
        $t = $t.$entry->get_value($rattr)."|".($entry->get_value($rattr)/($ctime-$stime1))."|";
    }

    $ldap->unbind;
    print "em_result=$t\n";
}
elsif ($MetricName eq "ReadOperationEtimes")
{
    $ldap->bind($username,password=>$passwd);
    $mesg = $ldap->search(filter=>"(objectclass=*)",base=>"cn=Monitor");
    @entries = $mesg->entries;
    $count = $mesg->count;
    $entry = $mesg->entry(0);
    $srtime = $entry->get_value("starttime");
    $stime1 = getTime($srtime);
    $srtime = $entry->get_value("currenttime");
    $ctime = getTime($srtime);
    $entry = $mesg->entry(4);
    @attrs = $entry->attributes();
    $t = "";
    @reqattrs = ("unauthbinds","simpleauthbinds","strongauthbinds");
    $binds=0;
    foreach $rattr (@reqattrs)
    {
        $binds = $binds + $entry->get_value($rattr);
    }
    @reqattrs = ("searchops","onelevelsearchops","wholesubtreesearchops");
    $searches=0;
    foreach $rattr (@reqattrs)
    {
        $searches = $searches + $entry->get_value($rattr);
    }

    $entry = $mesg->entry(1);
    $t = ($entry->get_value("bindetimesum")*1000)."|".($entry->get_value("bindetimesum")*1000)/$binds."|".$entry->get_value("bindetimesumsq")."|".$binds."|".($entry->get_value("unbindetimesum")*1000)."|".($entry->get_value("unbindetimesum")*1000)/$binds."|".$entry->get_value("unbindetimesumsq");

    $t = $t."|".$searches."|".($entry->get_value("searchetimesum")*1000)."|".($entry->get_value("searchetimesum")*1000)/$searches."|".$entry->get_value("searchetimesumsq");
   
    
    
    $ldap->unbind;
    print "em_result=$t\n";

}
elsif ($MetricName eq "CompareOperationEtimes")
{
    $ldap->bind($username,password=>$passwd);
    $mesg = $ldap->search(filter=>"(objectclass=*)",base=>"cn=Monitor");
    @entries = $mesg->entries;
    $count = $mesg->count;
    $entry = $mesg->entry(0);
    $srtime = $entry->get_value("starttime");
    $stime1 = getTime($srtime);
    $srtime = $entry->get_value("currenttime");
    $ctime = getTime($srtime);
    $entry = $mesg->entry(4);
    @attrs = $entry->attributes();
    $t = "";
    $compareops = $entry->get_value("compareops");
    $entry = $mesg->entry(1);
    $t = $compareops."|".($entry->get_value("compareetimesum")*1000)."|";
    if ($compareops > 0){
        $t = $t.($entry->get_value("compareetimesum")*1000)/$compareops."|";
    }
    else {
        $t = $t."0|";
    }
    $t=$t.$entry->get_value("compareetimesumsq");
    
    $ldap->unbind;
    print "em_result=$t\n";

}
elsif ($MetricName eq "WriteOperationEtimes")
{
    $ldap->bind($username,password=>$passwd);
    $mesg = $ldap->search(filter=>"(objectclass=*)",base=>"cn=Monitor");
    @entries = $mesg->entries;
    $count = $mesg->count;
    $entry = $mesg->entry(0);
    $srtime = $entry->get_value("starttime");
    $stime1 = getTime($srtime);
    $srtime = $entry->get_value("currenttime");
    $ctime = getTime($srtime);
    $entry = $mesg->entry(4);
    @attrs = $entry->attributes();
    $t = "";
    @ops = ("modifyentryops","addentryops","removeentryops","modifyrdnops");
    @etimes = ("modifyetimesum","addetimesum","deleteetimesum","modrdnetimesum");
    @opsvalue = ();
    $entry->get_value("modifyentryops");
    for($i=0; $i< @ops; $i++)
    {
        $opsvalue[$i] = $entry->get_value($ops[$i]);
    }
    $entry = $mesg->entry(1);
    for($i=0; $i < @ops; $i++)
    {
        $t = $t.$opsvalue[$i]."|".($entry->get_value($etimes[$i])*1000)."|";
        if ($opsvalue[$i] > 0){
            $t = $t.($entry->get_value($etimes[$i])*1000)/$opsvalue[$i]."|";
        }
        else {
            $t = $t."0|";
        }
        $t=$t.$entry->get_value($etimes[$i]."sq")."|";
    }
    
    $ldap->unbind;
    print "em_result=$t\n";

}
elsif ($MetricName eq "OtherOperations")
{
    $ldap->bind($username,password=>$passwd);
    $mesg = $ldap->search(filter=>"(objectclass=*)",base=>"cn=Monitor");
    @entries = $mesg->entries;
    $count = $mesg->count;
    $entry = $mesg->entry(0);
    $srtime = $entry->get_value("starttime");
    $stime1 = getTime($srtime);
    $srtime = $entry->get_value("currenttime");
    $ctime = getTime($srtime);
    $currentpsrch = $entry->get_value("currentpsearches");
    $entry = $mesg->entry(4);
    $t = "";
    @reqattrs = ("referrals");
    foreach $rattr (@reqattrs)
    {
        $t = $t.$entry->get_value($rattr)."|".($entry->get_value($rattr)/($ctime-$stime1))."|";
    }
    $ldap->unbind;

    print "em_result=".$currentpsrch."|".$t."\n";
}
elsif ($MetricName eq "INOUTOperations")
{
    $ldap->bind($username,password=>$passwd);
    $mesg = $ldap->search(filter=>"(objectclass=*)",base=>"cn=Monitor");
    @entries = $mesg->entries;
    $count = $mesg->count;
    $entry = $mesg->entry(0);
    $srtime = $entry->get_value("starttime");
    $stime1 = getTime($srtime);
    $srtime = $entry->get_value("currenttime");
    $ctime = getTime($srtime);
    $t = "";
    @reqattrs = ("entriessent","bytessent");
    foreach $rattr (@reqattrs)
    {
        $t = $t.$entry->get_value($rattr)."|".($entry->get_value($rattr)/($ctime-$stime1))."|";
    }
   
    $entry = $mesg->entry(4);
    @reqattrs = ("referralsreturned");
    foreach $rattr (@reqattrs)
    {
        $t = $t.$entry->get_value($rattr)."|".($entry->get_value($rattr)/($ctime-$stime1))."|";
    }


    $ldap->unbind;
    print "em_result=$t\n";
}
elsif ($MetricName eq "CacheMemThresholds")
{
    $ldap->bind($username,password=>$passwd);
    $mesg = $ldap->search(filter=>"(objectclass=*)",base=>"cn=Monitor");
    @entries = $mesg->entries;
    $count = $mesg->count;
    $entry = $mesg->entry(0);
    $srtime = $entry->get_value("starttime");
    $stime1 = getTime($srtime);
    $srtime = $entry->get_value("currenttime");
    $ctime = getTime($srtime);
    $t = "";
    @reqattrs = ("heapmaxhighhits","heapmaxlowhits");
    foreach $rattr (@reqattrs)
    {
        $t = $t.$entry->get_value($rattr)."|".($entry->get_value($rattr)/($ctime-$stime1))."|";
    }
   
    $ldap->unbind;
    print "em_result=$t\n";
}
elsif ($MetricName eq "Errors")
{
    $ldap->bind($username,password=>$passwd);
    $mesg = $ldap->search(filter=>"(objectclass=*)",base=>"cn=Monitor");
    $count = $mesg->count;
    $entry = $mesg->entry(0);
    $srtime = $entry->get_value("starttime");
    $stime1 = getTime($srtime);
    $srtime = $entry->get_value("currenttime");
    $ctime = getTime($srtime);
    $entry = $mesg->entry(4);
    $t = "";
    $errors=0;
    @reqattrs = ("securityerrors","errors","bindsecurityerrors");
    foreach $rattr (@reqattrs)
    {
        $t = $t.$entry->get_value($rattr)."|".($entry->get_value($rattr)/($ctime-$stime1))."|";
    }
    $errors = $entry->get_value("securityerrors") + $entry->get_value("errors");
    $t = $t.$errors."|".$errors/($ctime-$stime1);
   
    $ldap->unbind;
    print "em_result=$t\n";
}
elsif ($MetricName eq "Disks")
{
    $ldap->bind($username,password=>$passwd);
    $mesg = $ldap->search(filter=>"(objectclass=*)",base=>"cn=disk,cn=Monitor");
    $count = $mesg->count;
    @reqattrs = ("cn","disk-dir","disk-free","disk-state");
    for($i=1; $i < $count; $i++)
    {
        $t = "";
        $entry = $mesg->entry($i);
        foreach $rattr (@reqattrs)
        {
            $t = $t.$entry->get_value($rattr)."|";
        }
    
        print "em_result=$t\n";
    }
    $ldap->unbind;

}
elsif ($MetricName eq "DBCache")
{
    $ldap->bind($username,password=>$passwd);
    $mesg = $ldap->search(filter=>"(objectclass=*)",base=>"cn=Monitor");
    $count = $mesg->count;
    $entry = $mesg->entry(0);
    $srtime = $entry->get_value("starttime");
    $stime1 = getTime($srtime);
    $srtime = $entry->get_value("currenttime");
    $ctime = getTime($srtime);
    $mesg = $ldap->search(filter=>"(objectclass=*)",base=>"cn=monitor,cn=ldbm database,cn=plugins,cn=config");
    @entries = $mesg->entries;
    $entry = $mesg->entry(0);
    $t="";
    @reqattrs = ("dbcachehits","dbcachetries","dbcachepagein","dbcachepageout","dbcacheroevict","dbcacherwevict");
    foreach $rattr (@reqattrs)
    {
        $t = $t.$entry->get_value($rattr)."|".($entry->get_value($rattr)/($ctime-$stime1))."|";
    }

    $t = $t.$entry->get_value("dbcachehitratio")."|";
    @reqattrs = ("nsslapd-db-cache-region-wait-rate","nsslapd-db-page-create-rate","nsslapd-db-page-trickle-rate");
    $entry = $mesg->entry(1);
    foreach $rattr (@reqattrs)
    {
        $t = $t.$entry->get_value($rattr)."|".($entry->get_value($rattr)/($ctime-$stime1))."|";
    }
    $t = $t.$entry->get_value("nsslapd-db-clean-pages")."|".$entry->get_value("nsslapd-db-dirty-pages")."|".$entry->get_value("nsslapd-db-pages-in-use");
    
    $ldap->unbind;
    print "em_result=$t\n";

}
elsif ($MetricName eq "LocksDeadLocks")
{
    $ldap->bind($username,password=>$passwd);
    $mesg = $ldap->search(filter=>"(objectclass=*)",base=>"cn=Monitor");
    $count = $mesg->count;
    $entry = $mesg->entry(0);
    $srtime = $entry->get_value("starttime");
    $stime1 = getTime($srtime);
    $srtime = $entry->get_value("currenttime");
    $ctime = getTime($srtime);
    $mesg = $ldap->search(filter=>"(objectclass=*)",base=>"cn=monitor,cn=ldbm database,cn=plugins,cn=config");
    @entries = $mesg->entries;
    $t="";
    @reqattrs = ("nsslapd-db-lock-conflicts","nsslapd-db-deadlock-rate","nsslapd-db-lock-region-wait-rate","nsslapd-db-lock-request-rate");
    $entry = $mesg->entry(1);
    foreach $rattr (@reqattrs)
    {
        $t = $t.$entry->get_value($rattr)."|".($entry->get_value($rattr)/($ctime-$stime1))."|";
    }
     $t = $t.$entry->get_value("nsslapd-db-lockers")."|".$entry->get_value("nsslapd-db-current-locks")."|".$entry->get_value("nsslapd-db-max-locks");
    
    $ldap->unbind;
    print "em_result=$t\n";
}
elsif ($MetricName eq "Transactions")
{
    $ldap->bind($username,password=>$passwd);
    $mesg = $ldap->search(filter=>"(objectclass=*)",base=>"cn=Monitor");
    $count = $mesg->count;
    $entry = $mesg->entry(0);
    $srtime = $entry->get_value("starttime");
    $stime1 = getTime($srtime);
    $srtime = $entry->get_value("currenttime");
    $ctime = getTime($srtime);
    $mesg = $ldap->search(filter=>"(objectclass=*)",base=>"cn=monitor,cn=ldbm database,cn=plugins,cn=config");
    @entries = $mesg->entries;
    $t="";
    @reqattrs = ("nsslapd-db-abort-rate","nsslapd-db-commit-rate","nsslapd-db-txn-region-wait-rate");
    $entry = $mesg->entry(1);
    foreach $rattr (@reqattrs)
    {
        $t = $t.$entry->get_value($rattr)."|".($entry->get_value($rattr)/($ctime-$stime1))."|";
    }
     $t = $t.$entry->get_value("nsslapd-db-active-txns")."|".$entry->get_value("nsslapd-db-max-txns");
    
    $ldap->unbind;
    print "em_result=$t\n";
}
elsif ($MetricName eq "HashTable")
{
    $ldap->bind($username,password=>$passwd);
    $mesg = $ldap->search(filter=>"(objectclass=*)",base=>"cn=Monitor");
    $count = $mesg->count;
    $entry = $mesg->entry(0);
    $srtime = $entry->get_value("starttime");
    $stime1 = getTime($srtime);
    $srtime = $entry->get_value("currenttime");
    $ctime = getTime($srtime);
    $mesg = $ldap->search(filter=>"(objectclass=*)",base=>"cn=monitor,cn=ldbm database,cn=plugins,cn=config");
    @entries = $mesg->entries;
    $t="";
    @reqattrs = ("nsslapd-db-hash-elements-examine-rate","nsslapd-db-hash-search-rate");
    $entry = $mesg->entry(1);
    foreach $rattr (@reqattrs)
    {
        $t = $t.$entry->get_value($rattr)."|".($entry->get_value($rattr)/($ctime-$stime1))."|";
    }
     $t = $t.$entry->get_value("nsslapd-db-longest-chain-length");
    
    $ldap->unbind;
    print "em_result=$t\n";
}
elsif ($MetricName eq "TransactionLog")
{
    $ldap->bind($username,password=>$passwd);
    $mesg = $ldap->search(filter=>"(objectclass=*)",base=>"cn=Monitor");
    $count = $mesg->count;
    $entry = $mesg->entry(0);
    $srtime = $entry->get_value("starttime");
    $stime1 = getTime($srtime);
    $srtime = $entry->get_value("currenttime");
    $ctime = getTime($srtime);
    $mesg = $ldap->search(filter=>"(objectclass=*)",base=>"cn=monitor,cn=ldbm database,cn=plugins,cn=config");
    @entries = $mesg->entries;
    $t="";
    @reqattrs = ("nsslapd-db-log-region-wait-rate","nsslapd-db-log-write-rate","nsslapd-db-log-write-count","nsslapd-db-log-write-count-fill","nsslapd-db-log-flush-count","nsslapd-db-log-flush-commit");
    $entry = $mesg->entry(1);
    foreach $rattr (@reqattrs)
    {
        $t = $t.$entry->get_value($rattr)."|".($entry->get_value($rattr)/($ctime-$stime1))."|";
    }
     $t = $t.$entry->get_value("nsslapd-db-log-bytes-since-checkpoint")."|".$entry->get_value("nsslapd-db-log-max-commit-per-flush")."|".$entry->get_value("nsslapd-db-log-min-commit-per-flush");
    
    $ldap->unbind;
    print "em_result=$t\n";
}
elsif ($MetricName eq "BackendGeneralInfo")
{
    $ldap->bind($username,password=>$passwd);
    $mesg = $ldap->search(filter=>"(objectclass=*)",base=>"cn=Monitor");
    $count = $mesg->count;
    $entry = $mesg->entry(0);
    @names = $entry->get_value("backendmonitordn", asref=>1);
    $nbackends = $entry->get_value("nbackends");
    for($i=0; $i < $nbackends; $i++)
    {
        $mesg = $ldap->search(filter=>"(objectclass=*)",base=>$names[0][$i]);
        $entry = $mesg->entry(0);

        $res = $names[0][$i]."|";
        @reqattrs = ("readonly","nextid","dbentrycount","ldapentrycount");
        foreach $rattr (@reqattrs)
        {
            $res = $res.$entry->get_value($rattr)."|";

        }
        print "em_result=$res\n";
    }
    $ldap->unbind;

}
elsif ($MetricName eq "BackendEntryCache")
{
    $ldap->bind($username,password=>$passwd);
    $mesg = $ldap->search(filter=>"(objectclass=*)",base=>"cn=Monitor");
    $count = $mesg->count;
    $entry = $mesg->entry(0);
    $srtime = $entry->get_value("starttime");
    $stime1 = getTime($srtime);
    $srtime = $entry->get_value("currenttime");
    $ctime = getTime($srtime);
    @names = $entry->get_value("backendmonitordn", asref=>1);
    $nbackends = $entry->get_value("nbackends");
    for($i=0; $i < $nbackends; $i++)
    {
        $mesg = $ldap->search(filter=>"(objectclass=*)",base=>$names[0][$i]);
        $entry = $mesg->entry(0);

        $res = $names[0][$i]."|";
        @reqattrs = ("entrycachehits","entrycachetries");
        foreach $rattr (@reqattrs)
        {
            $res = $res.$entry->get_value($rattr)."|".($entry->get_value($rattr)/($ctime-$stime1))."|";

        }
        @reqattrs = ("entrycachehitratio","currententrycachesize","currententrycachecount");
        foreach $rattr (@reqattrs)
        {
            $res = $res.$entry->get_value($rattr)."|";
        }

        $res = $res.($entry->get_value("currententrycachesize")/$entry->get_value("currententrycachecount"));
        print "em_result=$res\n";
    }
    $ldap->unbind;

}
elsif ($MetricName eq "BackendFiles")
{
    $ldap->bind($username,password=>$passwd);
    $mesg = $ldap->search(filter=>"(objectclass=*)",base=>"cn=Monitor");
    $count = $mesg->count;
    $entry = $mesg->entry(0);
    $srtime = $entry->get_value("starttime");
    $stime1 = getTime($srtime);
    $srtime = $entry->get_value("currenttime");
    $ctime = getTime($srtime);
    @names = $entry->get_value("backendmonitordn", asref=>1);
    $nbackends = $entry->get_value("nbackends");
    @firstpart = ("dbfilename","dbfilecachehit", "dbfilecachemiss","dbfilepagein","dbfilepageout");
    # @reqattrs = ("-parentid","-nsuniqueid", "-member", "-id2entry","-pwdfailuretime","-nscpentrydn",,"-uid","--pwdgraceusetime","-givenname","-numsubordinates","-ancestorid","-owner","-mailalternateaddress","-aci","-cn","-telephonenumber","-seealso","-nsliprofilename","-pwdaccountlockedtime","-pipuid","-nswcalcalid","-nscalxitemid","-mail","-objectclass","-pipstatus","-uniquemember","-sn","-mailhost","-entrydn","-nsds5replconflict","-nsroledn");

    for($i=0; $i < $nbackends; $i++)
    {
        my @reqattrs = ();
        $mesg = $ldap->search(filter=>"(objectclass=*)",base=>$names[0][$i]);
        $entry = $mesg->entry(0);

        foreach my $attr ($entry->attributes)
        {
            if ($attr =~ m/^dbfilename/)
            {
                @data = split(/-/, $attr);
                # print "$data[1]\n";
                push(@reqattrs, "-".$data[1]);
            }
         }

        foreach $rattr (@reqattrs)
        {
            $res = $names[0][$i]."|";
            foreach $fattr (@firstpart)
            {
                if( $fattr eq "dbfilename")
                {
                    $res = $res.$entry->get_value($fattr.$rattr)."|";
                }else
                {
                    $res = $res.$entry->get_value($fattr.$rattr)."|".($entry->get_value($fattr.$rattr)/($ctime-$stime1))."|";
                }
            }
            print "em_result=$res\n";

        }

    }
    $ldap->unbind;

}



sub getTime()
{
    my $srtime = shift;
    $yr = substr($srtime,0,4);
    $mn = substr($srtime,4,2) - 1;
    $dd = substr($srtime,6,2);
    $hh = substr($srtime,8,2);
    $mm = substr($srtime,10,2);
    $ss = substr($srtime,12,2);
    $stime = timegm($ss,$mm,$hh,$dd,$mn,$yr);

    return $stime;
}

sub getResource() {
    my $IP = shift;
  my $os = `uname -s`;
  chomp ($os);
  my $numcpu = 1;
  my $totalmem = 1;
  my $pageSz = 1;

  if ($^O eq "linux") {
    $numcpu = `cat /proc/cpuinfo | grep processor | wc -l`;
    @PSINFO = `ps -e -o fname,ppid,pid,vsz,pmem,pcpu,%mem,cmd|grep ns-slapd | grep -i \"$IP\" | grep -v grep | grep -v perl`;
     $LINE = $PSINFO[0];
    @data = split(/\s+/, $LINE);
    @PSINFO = `top -p $data[2] -n 2 -bc`;

   foreach $processInfo (@PSINFO)
   {
    $processInfo =~ s/^\s+//;
    @dat = split(/\s+/, $processInfo);
      if($dat[0] eq  $data[2])
      {
          $mem = chop($dat[4]);
          #print "$processInfo\n";
          #print "$dat[4]\n";
          #print "$dat[8]\n";
          #print "$dat[9]\n";
          $dat[4] = $dat[4]*1024;
          return ($dat[4],$dat[8],$dat[9]);
      }
    }

    return(0,0,0);
    
  }
  elsif ($os eq "SunOS") {
    $numcpu = `kstat cpu_info | grep cpu_info | grep name | wc -l`;
    @PSINFO = `/usr/ucb/ps -auxww |grep ns-slapd | grep -i \"$IP\" | grep -v grep |
grep -v perl`;
     $LINE = $PSINFO[0];
    @data = split(/\s+/, $LINE);
 @PSINFO = `/bin/ps -efo fname,ppid,pid,vsz,pmem,pcpu,args | grep $data[1] | grep -v grep | grep -v perl`;
  }
  elsif ($os eq "OSF1" || $os eq "AIX") {
    $numcpu = `/usr/sbin/lscfg | grep proc | wc -l`;
    @PSINFO = `ps -ex -o vsz,pcpu,sz,comm,args|grep ns-slapd | grep -i \"$IP\" | grep -v grep | grep -v perl`;
  }
  elsif ($os eq "HP-UX") {
    $ENV{UNIX95} = "XPG4";
    $pageSz = `getconf _SC_PAGE_SIZE`;
    @PSINFO = `ps -e -o comm,ppid,pid,vsz,sz,pcpu|grep ns-slapd`;
  }
  else {
    print "Platform - $os not supported\n";
  }

  $mem = 0;
  $cpu = 0;
  my $memPct = 0.0;

  foreach $processInfo (@PSINFO)
  {
    print "$processInfo\n";
    @data = split(/\s+/, $processInfo);
    $cpu += $data[5];
    #if (1 == $data[1])
    {
      $mem += $data[3];

     if ($os eq "SunOS" || $os eq "OSF1" || $os eq "AIX" ) {
      $memPct += $data[4];
     }
     elsif ($os eq "HP-UX") {

      $memPct += $data[4];
     }
     else {
      $memPct += $data[6];
      }
    }
  }
  if ($os eq "HP-UX") {

      $memPct = $memPct * $pageSz;
      my ($vol,$dir,$file) =  File::Spec->splitpath( __FILE__);
      $totalmem = `$dir/../../../../bin/nmupm osLoad | grep em_result | awk 'BEGIN { FS="|"};{print \$9}'`;
      $memPct = ($memPct/($totalmem*1024))*100;
      $numcpu = `$dir/../../../../bin/nmupm osLoad | grep ncpus | awk 'BEGIN { FS="="};{print \$2}'`;

  }
  $cpu = $cpu/$numcpu;
    print "$mem\n";
    print "$cpu\n";
    print "$memPct\n";
  return ($mem, $cpu, $memPct);
}

sub getResourceNT() {
  #em_result=1572|oidldapd|N/A|3.47|0.00|36340|53600|0
  #           pid                    cpu  mem
  # we try to grep oidldapd
  @PSINFO = `nmupm TopProcs`;  
  
  $status = 0;
  $mem = 0;
  $cpu = 0;
  
  foreach $oidProcessInfo (@PSINFO) {
    $_ = $oidProcessInfo;
    if(/oidldapd/) {
      @data = split(/\|/, $oidProcessInfo);      
      $cpu += $data[4];
      $mem += $data[5];
      $status = 1;     
    }
  }
  @resource = ($mem, $cpu, $status);
  return @resource;
}
