#!/usr/local/bin/perl
# 
# $Header: emas/sysman/admin/scripts/iam/oamParseAssocConfig.pl /main/2 2012/06/05 01:45:46 proxy Exp $
#
# oamParseAssocConfig.pl
# 
# Copyright (c) 2012, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      oamParseAssocConfig.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      This script parses oam-config.xml to collect configuration metrics for OAM cluster 
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    rayleung    03/08/12 - Creation
# 

require "emd_common.pl";
use strict;
use ias::simpleXPath;
use ias::asecm;

my $domainHome = $ARGV[0];
my $option = $ARGV[1];

my $sep = "/";
if (( $^O =~ "Windows" ) || ($^O =~ "MSWin32"))
{
  $sep = "\\";
}

my $configFile = $domainHome.$sep."config".$sep."fmwconfig".$sep."oam-config.xml";
#EMD_PERL_DEBUG("configFile: ".$configFile."\n");

#LDAP type, host and port
if($option eq 'LDAP')
{
  my $ldapType;
  my $ldapUrl;
  my $ldapHost;
  my $ldapPort;

  my @oam = ias::simpleXPath::simpleXPathQueryForNodes($configFile, 'Configuration/Setting/Setting/Setting');
  foreach(@oam)
  {
    my @oamSetting = ias::simpleXPath::queryForAttributes($_, 'Setting');
    my $oamSettingName = $oamSetting[0]{"Name"};
    if($oamSettingName eq "LDAP")
    {
      my @ldap = ias::simpleXPath::queryForNodes($_, 'Setting/Setting');
      foreach(@ldap)
      {
        $ldapType = "";
        $ldapUrl = "";
        $ldapHost = "";
        $ldapPort = "";

        my @ldapProp = ias::simpleXPath::queryForNodes($_, 'Setting/Setting');
        foreach(@ldapProp)
        {
          my @ldapPropSetting = ias::simpleXPath::queryForAttributes($_, 'Setting');        
          my $ldapPropName = $ldapPropSetting[0]{"Name"};

          my @ldapPropText = ias::simpleXPath::queryForText($_, 'Setting');
          my $ldapPropValue = $ldapPropText[0];

          if($ldapPropName eq "LDAP_PROVIDER")
          {
            $ldapType = $ldapPropValue;
          }
          elsif($ldapPropName eq "LDAP_URL")
          {
            $ldapUrl = $ldapPropValue;
          }
        }
   
        if($ldapType ne "EMBEDDED_LDAP")
        {
          my @ldapUrlFields = split /:/, $ldapUrl;
          my $ldapHostField = $ldapUrlFields[1];
          my $ldapLastSlash = rindex($ldapHostField, "/");
          my $ldapHost = substr($ldapHostField, $ldapLastSlash + 1);
          my $ldapPort = $ldapUrlFields[2];

          ias::asecm::printResult(
            $ldapType, 'string',
            $ldapHost, 'string', 
            $ldapPort, 'string', 
          );
           
          #print("ldap type = ".$ldapType."\n");
          #print("ldap host = ".$ldapHost."\n");
          #print("ldap port = ".$ldapPort."\n");
        }
      }
    }
  }
}
#OIM host/port
elsif($option eq 'OIM')
{
  my $oimHost = "";
  my $oimPort = "";
  my $oimEnabled = "";

  my @oam = ias::simpleXPath::simpleXPathQueryForNodes($configFile, 'Configuration/Setting/Setting/Setting');
  foreach(@oam)
  {
    my @oamSetting = ias::simpleXPath::queryForAttributes($_, 'Setting');
    my $oamSettingName = $oamSetting[0]{"Name"};
    if($oamSettingName eq "Server")
    {
      my @server = ias::simpleXPath::queryForNodes($_, 'Setting/Setting/Setting');
      foreach(@server)
      {
        my @serverSetting = ias::simpleXPath::queryForAttributes($_, 'Setting');
        my $serverSettingName = $serverSetting[0]{"Name"};
        if($serverSettingName eq "Profile")
        {
          my @profile = ias::simpleXPath::queryForNodes($_, 'Setting/Setting');
          foreach(@profile)
          {
            my @profileSetting = ias::simpleXPath::queryForAttributes($_, 'Setting');
            my $profileSettingName = $profileSetting[0]{"Name"};
            if($profileSettingName eq "IdentityManagement")
            { 
              my @oim = ias::simpleXPath::queryForNodes($_, 'Setting/Setting');
              foreach(@oim)
              {
                my @oimSetting = ias::simpleXPath::queryForAttributes($_, 'Setting');
                my $oimSettingName = $oimSetting[0]{"Name"};
                if($oimSettingName eq "ServerConfiguration")
                {
                  my @oimService = ias::simpleXPath::queryForNodes($_, 'Setting/Setting/Setting');                 
                  foreach(@oimService)
                  { 
                    my @oimServiceSetting = ias::simpleXPath::queryForAttributes($_, 'Setting');
                    my $oimServiceName = $oimServiceSetting[0]{"Name"};

                    my @oimServiceText = ias::simpleXPath::queryForText($_, 'Setting');
                    my $oimServicePropValue = $oimServiceText[0];

                    if($oimServiceName eq "Host")
                    {
                      $oimHost = $oimServicePropValue;
                    }
                    elsif($oimServiceName eq "Port")
                    {
                      $oimPort = $oimServicePropValue;
                    }
                  }
                }
                elsif($oimSettingName eq "IdentityServiceConfiguration")
                {
                  my @oimService = ias::simpleXPath::queryForNodes($_, 'Setting/Setting');
                  foreach(@oimService)
                  {
                    my @oimServiceSetting = ias::simpleXPath::queryForAttributes($_, 'Setting');
                    my $oimServiceName = $oimServiceSetting[0]{"Name"};

                    if($oimServiceName eq "IdentityServiceEnabled")
		    {
                      my @oimServiceText = ias::simpleXPath::queryForText($_, 'Setting');
                      $oimEnabled = $oimServiceText[0];
                      #EMD_PERL_DEBUG("oimEnabled = ".$oimEnabled."\n");
                    }
                  }
                }
              }
              if($oimEnabled eq 'true')
              {
                ias::asecm::printResult(
                $oimHost, 'string', 
                $oimPort, 'string', 
                );
              }
              #EMD_PERL_DEBUG("oimHost = ".$oimHost."\n");
              #EMD_PERL_DEBUG("oimPort = ".$oimPort."\n");
              #EMD_PERL_DEBUG("oimEnabled = ".$oimEnabled."\n");
            }
          }
	}
      }
    }
  }
}
#OAM host, port/proxy port
elsif($option eq 'Server')
{
  my $oamServer;
  my $oamHost;
  my $oamPort;
  my $oamProxyPort;
  my $isDeployed;
  
  my @oam = ias::simpleXPath::simpleXPathQueryForNodes($configFile, 'Configuration/Setting/Setting/Setting');
  foreach(@oam)
  {
    my @oamSetting = ias::simpleXPath::queryForAttributes($_, 'Setting');
    my $oamSettingName = $oamSetting[0]{"Name"};
    if($oamSettingName eq "Server")
    {
      my @server = ias::simpleXPath::queryForNodes($_, 'Setting/Setting/Setting');
      foreach(@server)
      {
        my @serverSetting = ias::simpleXPath::queryForAttributes($_, 'Setting');
        my $serverSettingName = $serverSetting[0]{"Name"};
        if($serverSettingName eq "Instance")
        {
          my @instance = ias::simpleXPath::queryForNodes($_, 'Setting/Setting');
          foreach(@instance)
          {
            $oamServer = "";
            $oamHost = "";
            $oamPort = "";
            $oamProxyPort = "";
            $isDeployed = "";
  
            my @instanceSetting = ias::simpleXPath::queryForAttributes($_, 'Setting');
            $oamServer = $instanceSetting[0]{"Name"};
            my @instanceProp = ias::simpleXPath::queryForNodes($_, 'Setting/Setting');
            foreach(@instanceProp)
            {
              my @instancePropSetting = ias::simpleXPath::queryForAttributes($_, 'Setting');
              my $instancePropName = $instancePropSetting[0]{"Name"};
  
              my @instancePropText = ias::simpleXPath::queryForText($_, 'Setting');
              my $instancePropValue = $instancePropText[0];
  
              if($instancePropName eq "OAMServer")
              {
                $isDeployed = $instancePropValue;
              }
              elsif($instancePropName eq "host")
              {
                $oamHost = $instancePropValue;
              }
              elsif($instancePropName eq "port")
              {
                $oamPort = $instancePropValue;
              }
              elsif($instancePropName eq "oamproxy")
              {
                my @oamProxy = ias::simpleXPath::queryForNodes($_, 'Setting/Setting');
                foreach(@oamProxy)
                {
                  my @oamProxySetting = ias::simpleXPath::queryForAttributes($_, 'Setting');
                  my $oamProxySettingName = $oamProxySetting[0]{"Name"};
                  if($oamProxySettingName eq "Port")
                  {
                     my @oamProxyPropText = ias::simpleXPath::queryForText($_, 'Setting');
                     $oamProxyPort = $oamProxyPropText[0];
                  }               
                }
              }
  
            }
            if($isDeployed eq 'true')
            {
              ias::asecm::printResult(
                $oamServer, 'string',
                $oamHost, 'string', 
                $oamPort, 'string', 
                $oamProxyPort, 'string', 
              );
            
              #print("server = ".$oamServer."\n");
              #print("host = ".$oamHost."\n");
              #print("port = ".$oamPort."\n");
              #print("proxy = ".$oamProxyPort."\n");
            }
            #EMD_PERL_DEBUG("oamServer = ".$oamServer."\n");
            #EMD_PERL_DEBUG("oamHost = ".$oamHost."\n");
            #EMD_PERL_DEBUG("oamPort = ".$oamPort."\n");
            #EMD_PERL_DEBUG("oamProxyPort = ".$oamProxyPort."\n");
            #EMD_PERL_DEBUG("oamDeployed = ".$isDeployed."\n");
          }
        }
      }
    }
  }
}

#Agent configuration
elsif($option eq 'Agent')
{
  my $agentName;
  my $maxConns;
  my $cachePragmaHdr;
  my $cacheControlHdr;

  my @oam = ias::simpleXPath::simpleXPathQueryForNodes($configFile, 'Configuration/Setting/Setting/Setting');
  foreach(@oam)
  {
    my @oamSetting = ias::simpleXPath::queryForAttributes($_, 'Setting');
    my $oamSettingName = $oamSetting[0]{"Name"};
    if($oamSettingName eq "Agent")
    {
      my @webGate = ias::simpleXPath::queryForNodes($_, 'Setting/Setting');
      foreach(@webGate)
      {
        my @webGateSetting = ias::simpleXPath::queryForAttributes($_, 'Setting');
        my $webGateSettingName = $webGateSetting[0]{"Name"};
        if($webGateSettingName eq "WebGate")
        {
          my @setting = ias::simpleXPath::queryForNodes($_, 'Setting/Setting');
          foreach(@setting)
          {
            my @settings = ias::simpleXPath::queryForAttributes($_, 'Setting');
            my $settingsName = $settings[0]{"Name"};
            if($settingsName eq "Instance")
            {
              my @instance = ias::simpleXPath::queryForNodes($_, 'Setting/Setting');
              foreach(@instance)
              {
                $agentName = "";
                $maxConns = "";
                $cachePragmaHdr = "";
                $cacheControlHdr = "";
                my @instanceSetting = ias::simpleXPath::queryForAttributes($_, 'Setting');
                $agentName = $instanceSetting[0]{"Name"};

                my @instanceProp = ias::simpleXPath::queryForNodes($_, 'Setting/Setting');
                foreach(@instanceProp)
                {
                  my @instancePropSetting = ias::simpleXPath::queryForAttributes($_, 'Setting');
                  my $instancePropName = $instancePropSetting[0]{"Name"};
                  my @instancePropText = ias::simpleXPath::queryForText($_, 'Setting');
                  my $instancePropValue = $instancePropText[0];

                  if($instancePropName eq "maxConnections")
                  {
                    $maxConns = $instancePropValue;
                  }
                  elsif($instancePropName eq "cachePragmaHeader")
                  {
                    $cachePragmaHdr = $instancePropValue;
                  }
                  elsif($instancePropName eq "cacheControlHeader")
                  {
                    $cacheControlHdr = $instancePropValue;
                  }
                }
              }
              ias::asecm::printResult(
                $agentName, 'string',
                $maxConns, 'number', 
                $cachePragmaHdr, 'string', 
                $cacheControlHdr, 'string', 
              );
            }
          }
        }
      }
    }
  }
}

#Agent Server Configuration
elsif($option eq 'AgentServer')
{
  my $agentName;
  my $serverType;
  my $serverHost;
  my $serverPort;
  my $maxConns;

  my @oam = ias::simpleXPath::simpleXPathQueryForNodes($configFile, 'Configuration/Setting/Setting/Setting');
  foreach(@oam)
  {
    my @oamSetting = ias::simpleXPath::queryForAttributes($_, 'Setting');
    my $oamSettingName = $oamSetting[0]{"Name"};
    if($oamSettingName eq "Agent")
    {
      my @webGate = ias::simpleXPath::queryForNodes($_, 'Setting/Setting');
      foreach(@webGate)
      {
        my @webGateSetting = ias::simpleXPath::queryForAttributes($_, 'Setting');
        my $webGateSettingName = $webGateSetting[0]{"Name"};
        if($webGateSettingName eq "WebGate")
        {
          my @setting = ias::simpleXPath::queryForNodes($_, 'Setting/Setting');
          foreach(@setting)
          {
            my @settings = ias::simpleXPath::queryForAttributes($_, 'Setting');
            my $settingsName = $settings[0]{"Name"};
            if($settingsName eq "Instance")
            {
              my @instance = ias::simpleXPath::queryForNodes($_, 'Setting/Setting');
              foreach(@instance)
              {
                $agentName = "";
                my @instanceSetting = ias::simpleXPath::queryForAttributes($_, 'Setting');
                $agentName = $instanceSetting[0]{"Name"};

                my @instanceProp = ias::simpleXPath::queryForNodes($_, 'Setting/Setting');
                foreach(@instanceProp)
                {
                  my @serverTags = ias::simpleXPath::queryForAttributes($_, 'Setting');
                  my $serverTagsText = $serverTags[0]{"Name"};
                  $serverType = "";
                  $serverHost = "";
                  $serverPort = "";
                  $maxConns = "";
                  if(($serverTagsText eq "PrimaryServerList") || $serverTagsText eq "SecondaryServerList")
                  {
                    if($serverTagsText eq "PrimaryServerList")
                    {
                      $serverType = "Primary";
                    }
                    else
                    {
                      $serverType = "Secondary";
                    }
                    my @serverAttributes = ias::simpleXPath::queryForNodes($_, 'Setting/Setting/Setting');
                    foreach(@serverAttributes)
                    {
                      my @attributeValues = ias::simpleXPath::queryForAttributes($_, 'Setting');
                      my $attributeValuesName = $attributeValues[0]{"Name"};
                      my @attributeValuesText = ias::simpleXPath::queryForText($_, 'Setting');
                      my $attributeValue = $attributeValuesText[0];

                      if($attributeValuesName eq "host")
                      {
                        $serverHost = $attributeValue;
                      }
                      elsif($attributeValuesName eq "port")
                      {
                        $serverPort = $attributeValue;
                      }
                      elsif($attributeValuesName eq "numOfConnections")
                      {
                        $maxConns = $attributeValue;
                      }
                    }
                    if(length($serverHost)>0)
                    {
                      ias::asecm::printResult(
                        $agentName, 'string',
                        $serverType, 'string',
                        $serverHost, 'string',
                        $serverPort, 'string',
                        $maxConns, 'number', 
                      );
                    }
                  }
                }
              }
              
            }
          }
        }
      }
    }
  }
}
