# $Header: oidPID.pl 22-feb-2006.17:42:34 jxwei Exp $
#
# oidPID.pl
# 
# Copyright (c) 2001, 2006, Oracle. All rights reserved.  
#
#    NAME
#      oidPID.pl - get all the process for ldap
#
#    DESCRIPTION
#      This script computes for Oracle Internet Directory Server 
#      the process size in VM, % physical memory and %CPU consumption
#
#    NOTES
#      USAGE oidPID.pl
#
#    MODIFIED   (MM/DD/YY)
#    stakeda     06/06/30 - snapshot of LDAP_10.1.4.0.1_LINUX_060628
#    jxwei       02/22/06 - 
#    vsekuboy    10/21/02 - Added ENV for PATH
#    vsekuboy    10/18/02 - Changes for HP, Linux, AIX and Tru64
#    xxu         06/25/02 - remove /usr/local/bin/perl
#    achoudha    12/12/01 -
#    achoudha    12/12/01 - Creation
# 

$ENV{PATH} = "/bin:/usr/bin:/usr/local/bin:/usr/sbin";

chomp ($os = `uname -s`);
if ($os eq "SunOS" || $os eq "Linux") {
   @PSINFO = `ps -e -o fname,ppid,pid|grep oidldapd`;
}
elsif ($os eq "OSF1" || $os eq "AIX") {
   @PSINFO = `ps -e -o comm,ppid,pid|grep oidldapd`;
}
elsif ($os eq "HP-UX") {
   $ENV{UNIX95} = "XPG4";
   @PSINFO = `ps -e -o comm,ppid,pid|grep oidldapd`;
}
else {
   print "Platform - $os not supported\n";
}

$procID = 0;


$PID    = 0;

foreach $oidProcessInfo (@PSINFO)
{
    @data = split(/\s+/, $oidProcessInfo);
    if(1 == $data[1]) {
       $PID = $data[2];
       print "em_result=$PID\n";
    }
}
