#  $Header: oidServerMem.pl 22-feb-2006.17:42:35 jxwei Exp $
# 
# Copyright (c) 2001, 2006, Oracle. All rights reserved.  
#
#    NAME
#      oidServerMem.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      This script computes for Oracle Internet Directory processes,
#      the total size in KB, of all LDAP server instances.  
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    stakeda     06/06/30 - snapshot of LDAP_10.1.4.0.1_LINUX_060628
#    jxwei       02/22/06 - 
#    xshi        05/01/03 - fix for metric collect
#    vsekuboy    10/21/02 - Changes for HP, Linux, Tru64 and AIX
#    xxu         06/25/02 - remove /usr/local/bin/perl
#    xshi        09/13/01 - Creation
#

$oldPATH = $ENV{"PATH"};
$ENV{PATH} = "/bin:/usr/bin:/usr/local/bin:/usr/sbin:/usr/ucb";
chomp ($os = `uname -s`);

chomp ($os = `uname -s`);
if ($os eq "SunOS" || $os eq "Linux") {
   @PSINFO = `ps -e -o fname,vsz,ppid|grep oidldapd`;
}
elsif ($os eq "OSF1" || $os eq "AIX") {
   @PSINFO = `ps -e -o comm,vsz,ppid|grep oidldapd`;
}
elsif ($os eq "HP-UX") {
   $ENV{UNIX95} = "XPG4";
   @PSINFO = `ps -e -o comm,vsz,ppid|grep oidldapd`;
}
else {
   print "Platform - $os not supported\n";
}

$sz     = 0;

foreach $oidProcessInfo (@PSINFO)
{
  @data = split(/\s+/, $oidProcessInfo);
  if( 1 == $data[2] )
  {
     $sz  += $data[1];
  }
}

print "em_result=$sz\n";

$ENV{PATH} = $oldPATH;

