#!/usr/local/bin/perl
# 
# $Header: emas/sysman/admin/scripts/iam/oimParseAssocConfig.pl /main/1 2012/04/15 03:56:27 rahgupta Exp $
#
# oimParseAssocConfig.pl
# 
# Copyright (c) 2012, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      oimParseAssocConfig.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    rayleung    03/07/12 - Creation
# 

require "emd_common.pl";
use strict;
use ias::simpleXPath;
use ias::asecm;

my $agentState = $ARGV[0];
my $targetName = $ARGV[1];
my $displayName = substr($targetName, 1);	# trim the first "/"

my $sep = "/";
if (( $^O =~ "Windows" ) || ($^O =~ "MSWin32"))
{
  $sep = "\\";
  $displayName =~ s/\//\\/;
}

my $configFile = $agentState.$sep."oim_config".$sep.$displayName.$sep."db".$sep."oim-config.xml";
#EMD_PERL_DEBUG("configFile: ".$configFile."\n");

#OIM Host/Port
my @oim = ias::simpleXPath::simpleXPathQueryForText($configFile,'xmlConfig/discoveryConfig/oimFrontEndURL');
my $oimurl = $oim[0];
my @oimurlFields = split /:/, $oimurl;
my $oimHostField = $oimurlFields[1];
my $oimLastSlash = rindex($oimHostField, "/");
my $oimHost = substr($oimHostField, $oimLastSlash + 1);
my $oimPort = $oimurlFields[2];
#EMD_PERL_DEBUG("oimHost: ".$oimHost."\n");
#EMD_PERL_DEBUG("oimPort: ".$oimPort."\n");

#DB Host/Port/ServiceName
my @db = ias::simpleXPath::simpleXPathQuery($configFile,'xmlConfig/discoveryConfig/directDBConfigParams');
my $dburl = $db[0]{'url'};
my @dbSlash = split /\//, $dburl;
my $dbServiceName = $dbSlash[1];
my $dbConn = $dbSlash[0];
my @dbConnFields = split /@/, $dbConn;
my @dbHostPort = split /:/, $dbConnFields[1];
my $dbHost = $dbHostPort[0];
my $dbPort = $dbHostPort[1];
#EMD_PERL_DEBUG("dbHost: ".$dbHost."\n");
#EMD_PERL_DEBUG("dbPort: ".$dbPort."\n");
#EMD_PERL_DEBUG("dbServiceName: ".$dbServiceName."\n");

#SOA Host/Port
my @soa = ias::simpleXPath::simpleXPathQueryForText($configFile,'xmlConfig/SOAConfig/rmiurl');
my $soarmiurl = $soa[0];
my @soaFields = split /:/, $soarmiurl;
my $soaPort = $soaFields[2];
my $soaLastSlash = rindex($soaFields[1], "/");
my $soaHost = substr($soaFields[1], $soaLastSlash + 1);
#EMD_PERL_DEBUG("soaHost: ".$soaHost."\n");
#EMD_PERL_DEBUG("soaPort: ".$soaPort."\n");

#OAM Host/Port
my @sso_enabled;
@sso_enabled = ias::simpleXPath::simpleXPathQueryForText($configFile,'xmlConfig/ssoConfig/ssoEnabled');
my $ssoEnabled = $sso_enabled[0];
#EMD_PERL_DEBUG("ssoEnabled: ".$ssoEnabled."\n");
my $oamHost;
my $oamPort;
if($ssoEnabled eq 'true')
{
    my @oam_host;
    @oam_host = ias::simpleXPath::simpleXPathQueryForText($configFile,'xmlConfig/ssoConfig/accessServerHost');
    $oamHost = $oam_host[0];

    my @oam_port;
    @oam_port = ias::simpleXPath::simpleXPathQueryForText($configFile,'xmlConfig/ssoConfig/accessServerPort');
    $oamPort = $oam_port[0];
}
else
{
    $oamHost = "";
    $oamPort = "";
}
#EMD_PERL_DEBUG("oamHost: ".$oamHost."\n");
#EMD_PERL_DEBUG("oamPort: ".$oamPort."\n");

ias::asecm::printResult(
    $oimHost, 'string',
    $oimPort, 'string', 
    $dbHost, 'string', 
    $dbPort, 'string', 
    $dbServiceName,  'string', 
    $soaHost, 'string', 
    $soaPort, 'string',
    $oamHost, 'string',
    $oamPort, 'string',
);
