#!/usr/local/bin/perl
# 
# $Header: emas/sysman/admin/scripts/iam/weblogicResUsage.pl /main/6 2011/04/15 11:42:43 kchander Exp $
#
# weblogicResUsage.pl
# 
# Copyright (c) 2009, 2011, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      weblogicResUsage.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    kchander    01/13/11 - ps3 sync to main
#    akarkala    12/08/09 - bug-8585775
#    rayleung    08/16/10 - Bug 10023287
#    kchander    04/16/10 - fix bug 9592163.
#    kchander    03/18/10 - Fix HP UX issue.
#    kchander    02/15/10 - fix bug 9362269.
#    akarkala    05/26/09 - Need to introduce delay between cpu samples in
#                           windows
#    akarkala    03/30/09 - bug-8369199
#    akarkala    03/16/09 - A perl script that will load the weblogic RU
#                           metrics
#    akarkala    03/16/09 - Creation
# 



#######################
#Usage
# perl weblogicResUsage.pl <wls_server_home> <wls_server_name>
#examples
# perl weblogicResUsage.pl /disk1/oh1/bin/wlserver103 AdminServer
# perl weblogicResUsage.pl /disk1/oh1/bin/wlserver103 Server1
#
#o/p totalmemused|mem%|cpu%|command
#Note: totalmemused -> KB
#######################

use File::Spec;

$cmdlen = $#ARGV + 1;
if($cmdlen < 2) {
	print "Must specify wlshome and wlsservername\n";
	exit(1);
}

#global params
$srv_home = $ARGV[0];
$srv_name = $ARGV[1];

my $pageSz = 1;
#check os type
my $os_tmp = $^O;
if(($os_tmp =~ "Win") || ($os_tmp =~ "MSWin32")) {
    #All win32 code here
    my $out = getResourceWin($srv_name);
    print $out;
} 
else {
    #All unix code here
    $ENV{PATH} = "/usr/bin:/usr/sbin:/usr/local/bin:/local/bin:/bin";
    my $os = `uname -s`;
    my $numcpu = 1;
    chomp ($os);
    if ($os eq "Linux") {
        $numcpu = `cat /proc/cpuinfo | grep processor | wc -l`;
        @PSINFO = `ps -e -o vsize,pcpu,pmem,cmd | grep -i weblogic | grep -i \"$ARGV[0]\" | grep -i \"$ARGV[1]\" |grep -v grep | grep -v perl`;
    }
    elsif ($os eq "SunOS") {
        $numcpu = `kstat cpu_info | grep cpu_info | grep name | wc -l`;
        @PSINFO = `/usr/ucb/ps ww | grep -i weblogic | grep -i \"$ARGV[0]\" | grep -i \"$ARGV[1]\" |grep -v grep | grep -v perl | cut -d\" \" -f2`;
        @PSINFO = `ps -e -o vsz,pcpu,pmem,pid | grep $PSINFO[0]`;
    }
    elsif ($os eq "HP-UX") {
		$ENV{UNIX95} = "XPG4";
		$pageSz = `getconf _SC_PAGE_SIZE`;
        @PSINFO = `ps -ex -o vsz,pcpu,sz,comm,args | grep -i weblogic | grep -i \"$ARGV[0]\" | grep -i \"$ARGV[1]\" |grep -v grep | grep -v perl`;
    }
    elsif ($os eq "OSF1" || $os eq "AIX") {
        $numcpu = `/usr/sbin/lscfg | grep proc | wc -l`;
        # @PSINFO = `/usr/bin/ps -ef | grep -i java | grep  \"$ARGV[0]\" | grep  \"$ARGV[1]\" | cut -d\" \" -f2`;
        # print "---$PSINFO[0]\n";
        @PSINFO = `/usr/bin/ps -e -o vsz,pcpu,pmem,pid,args | grep -i weblogic | grep -i \"$ARGV[0]\" | grep -i \"$ARGV[1]\" |grep -v grep | grep -v perl`;
    }
    
    my $mempt=0;
    my $cpupt=0;
    my $memtotal=0;
    my $cmd="";
    
    $pscount = $#PSINFO + 1;
    if($pscount > 1) {
            print "Unable to resolve WLS process\n";
            exit(1);
    }
    
    foreach $ps (@PSINFO) {
            @data = split(/\s+/,$ps);
            $mempt=$data[2];
            $memtotal=$data[0];
            #$memtotal = ($memtotal * 1024);
            $cpupt=$data[1];
            $cmd=$data[3];
            #print "$ps\n";
    }
 if ($os eq "HP-UX") {

    foreach $ps (@PSINFO) {
       @data = split(/\s+/,$ps);
      $cpupt=$data[2];
      $mempt=$data[3];
      $memtotal=$data[1];
  }
      $mempt = $mempt * $pageSz;
      my ($vol,$dir,$file) =  File::Spec->splitpath( __FILE__);
      $totalmem = `$dir/../../../../bin/nmupm osLoad | grep em_result | awk 'BEGIN { FS="|"};{print \$9}'`;
      $mempt = ($mempt/($totalmem*1024))*100;
      $numcpu = `$dir/../../../../bin/nmupm osLoad | grep ncpus | awk 'BEGIN { FS="="};{print \$2}'`;

  }
    $cpupt = $cpupt/$numcpu;
    $op = "em_result=$memtotal|$mempt|$cpupt|$cmd\n";
    print $op;
}

# This function will compute the cpupt and mem total used by the weblogic process
# defined with the servername (AdminServer/MS1 etc). 
# NOTE: Currently we donot consider the ORACLE_HOME .. so if there are 2 SH installations
# on the same box we need to make the change.
sub getResourceWin() {
    my $op;
    my $server = $_[0];
    my $cmdline;
    my $pid;
    my $memusagekb;
    my $totalmemkb; #includes physical mem + virtual mem
    my $cpupt = 0;
    my $mempt = 0;
    ($memusagekb,$pid,$cmdline) = getMEMUsageForServer($server);
    if($pid < 1) {
	$op="em_result=0|0|0||";
	return $op;
    }

    #%cpu computation
    my $num1;
    my $num1;
    my $den1;
    my $den2;    
    ($num1,$den1) = getCPUUsageForPID($pid);
    #print "$num1,$den1\n";
    #Sleep for a while so that the next cpu sample has some diff data.
    sleep 2;
    ($num2,$den2) = getCPUUsageForPID($pid);
    #print "$num2,$den2\n";
    my $den = $den2-$den1;
    if($den > 0) {
	my $num = $num2 - $num1;
	$cpupt = 100 *($num/$den);
	my $cpucount = getNumOfProcessors();
	if($cpucount > 0) {
		$cpupt = $cpupt/$cpucount;
	}
	if($cpupt > 100) {
		$cpupt=100.0;
	}
    }
    
    #total mem computation
    $totalmemkb = getTotalConfiguredMemForWin();
    if($totalmemkb > 0) {
	    $mempt = ($memusagekb/$totalmemkb)*100;
	    if($mempt > 100) {
		    $mempt = 100;
	    }
    }

    $op="em_result=$memusagekb|$mempt|$cpupt|$cmdline";
    return $op;
}

#this method gets the total memory configured on this box
#the return will be the total memory in kb
sub getTotalConfiguredMemForWin {
	my $ret = 0;
	my $cmd1 = "%SYSTEMROOT%\\system32\\wbem\\wmic path Win32_LogicalMemoryConfiguration where (Name='LogicalMemoryConfiguration') get TotalPageFileSpace /format:list";
	my $results = `$cmd1`;
	#print $results;
	if ($results) {
		my @results = split (/\n/,$results);
		my $mem = $results[2];
		#print $mem . "\n";
		my @tmp = split(/TotalPageFileSpace=/,$mem);
		$mem = $tmp[1];
		$mem = removeCRNL($mem);
		#print $mem . "\n";
		$ret = $mem;
	}
	return $ret;
}

# This method computes the total mem used by the wls process and also determines its PID and command line
sub getMEMUsageForServer {
	my $server = $_[0];
	#print $server . "\n";
	my $cmd1 = "%SYSTEMROOT%\\system32\\wbem\\wmic path win32_process where(commandLine like '%weblogic.server%' and commandLine like '%$server%' and NOT commandLine like 'wmic%' and NOT commandLine like 'cmd%') get commandLine, ProcessId, WorkingSetSize /format:list";
	my $results = `$cmd1`;
	#print $results;
	if ( $results ) {
		my @results = split (/\n/,$results);
		my $cmdline = $results[2];
		my @tmp = split(/CommandLine=/,$cmdline);
		$cmdline = $tmp[1];
		$cmdline = removeCRNL($cmdline);
		#print $cmdline . "\n";

		my $pid = $results[3];
		@tmp = split(/ProcessId=/,$pid);
		$pid = removeCRNL($tmp[1]);
		#print $pid . "\n";

		my $memusagekb = $results[4];
		@tmp = split(/WorkingSetSize=/,$memusagekb);
		$memusagekb = removeCRNL($tmp[1]);
		#note that memusagekb here is in bytes. What is expected is kb
		if($memusagekb > 0) {
			$memusagekb = $memusagekb/1024;
		}
		#print $memusagekb . "\n";

		#print $memusagekb . "\n";	
		#print $cmdline . "\n";
		#print $pid . "\n";
		@ret = ($memusagekb,$pid,$cmdline);
	}
	return @ret;
}

#removes any carriage return/line feed from the given string and returns it back
sub removeCRNL {
	my $in = $_[0];
	$in =~ s/\r|\n//g;
	return $in;
}


#
# Quueries WMI to get a snapshot of the cpu usage counter for the given process ID. To derive meaning from this counter
# we must take two snapshots and calculate difference. 
# Here is an useful tutorial on wmi counters -> http://msdn.microsoft.com/en-us/library/ms974615.aspx
# WMI class -> Win32_PerfRawData_PerfProc_Process Column used: PercentProcessorTime
# Class definition on MSDN -> http://msdn.microsoft.com/en-us/library/aa394323(VS.85).aspx
# PercentProcessorTime counter type CounterType(542180608) (http://msdn.microsoft.com/en-us/library/aa389383(VS.85).aspx)
# Counter type -> 	PERF_100NSEC_TIMER
# counter definition on MSDN (with formula) -> http://msdn.microsoft.com/en-us/library/ms803979.aspx
#
sub getCPUUsageForPID {
	my $in = $_[0];
	my @ret;
	my $cmd1 = "%SYSTEMROOT%\\system32\\wbem\\wmic path Win32_PerfRawData_PerfProc_Process where(IDProcess=$in) get PercentProcessorTime, Timestamp_Sys100NS /format:list";
	#print $cmd1;
	my $results=`$cmd1`;
	#print $results;
	if($results) {
		@results = split (/\n/,$results);
		my $top = $results[2];
		my @tmp = split(/PercentProcessorTime=/,$top);
		$top = removeCRNL($tmp[1]);
		#print $top;

		my $down = $results[3];
		@tmp = split(/Timestamp_Sys100NS=/,$down);
		$down = removeCRNL($tmp[1]);
		#print $down;
		@ret = ($top,$down);
	}
	return @ret;
}

sub getNumOfProcessors {
	my $cmd1 = "%SYSTEMROOT%\\system32\\wbem\\wmic path Win32_ComputerSystem  get NumberOfProcessors /format:list";
	my $results=`$cmd1`;
	my $ret = 1;
	#print $results;
	if($results) {
		#print "processing results\n";
		@results = split(/\n/,$results);
		#print "Array size". @results . "\n";
		my $ln = $results[2];
		$ln = removeCRNL($ln);
		#print "line:" . $ln . ":\n";
		@ln = split(/NumberOfProcessors=/,$ln);
		$ln = $ln[1];
		#print "line:" . $ln . ":\n";
		$ret = $ln;
	}
	return $ret;
}
