# 
# $Header: emas/sysman/admin/scripts/ias.10g/AS11OHS_confFileParser.pm /main/5 2011/08/29 20:20:46 smariswa Exp $

#
# Apache_confFileParser.pm

# 
# Copyright (c) 2004, 2011, Oracle and/or its affiliates. All rights reserved. 

#
#    NAME

#      Apache_confFileParser.pm - Apache .conf file parser

#

#    DESCRIPTION

#      Parses an Apache .conf file.

#

#      Entry points:

#       parseConfFile

#       peek

#

#    NOTES

#      <other useful comments, qualifications, etc.>

#

#    MODIFIED   (MM/DD/YY)
#    smariswa    08/26/11 - Support SSL
#    rummadi     08/26/09 - Copied Apache_confFileParser.pm to AS11OHS_confFileParser.pm

#                            to get rid of dependencies on file path.

#    jsmoler     04/23/08 - Backport jsmoler_bug-6319688 from main

#    jsmoler     07/18/07 - Backport jsmoler_bug-5736476_test_070712 from

#                           st_emasgc_10.2.0.1.0

#    jsmoler     12/28/06 - handle absolute and relative paths (bug 5736476)

#    jsmoler     08/07/06 - Backport jsmoler_bug-5224028 from main

#    jsmoler     06/26/06 - don't die on all errors 

#    jsmoler     08/07/06 - Backport jsmoler_bug-5295826 from

#                           st_emasgc_10.2.0.1.0

#    jsmoler     04/06/06 - fix bug 5143034

#    jsmoler     08/02/06 - Backport jsmoler_bug-5143034 from main

#    jsmoler     08/02/06 - Backport jsmoler_bug-5046383 from main

#    jsmoler     11/01/05 - XbranchMerge jsmoler_bug-4613189 from main 

#    jsmoler     03/06/06 - add package statement 

#    jsmoler     09/29/05 - change module handling

#    jsmoler     02/28/05 - inherit simple directives

#    jsmoler     02/10/05 - handle simple directive with no arguments

#    jsmoler     10/22/04 - move "sub contains" to asecm 

#    jsmoler     10/07/04 - some support for default values

#    jsmoler     10/04/04 - jsmoler_ecm01

#    jsmoler     08/18/04 - Creation

# 



#

# Apache directive names are case insensitive. Since they are stored in a hash by

# the parser, use a tied hash that converts all keys to lower case.

#

{

    package ias::Apache_confFileParser::LowerCaseHash;



    require Tie::Hash;

    @ISA = qw(Tie::StdHash);



    sub STORE

    {

        $_[0]{lc($_[1])} = $_[2];

    }

    sub FETCH 

    {

        return $_[0]{lc($_[1])};

    }

}



BEGIN

{

    require "emd_common.pl";

}



package ias::AS11OHS_confFileParser;



use strict;

use Exporter 'import';

use File::Spec;

use ias::webtierConfig;

use File::Spec::Functions;

use IPC::Open3;

use IO::Handle;

use Data::Dumper;

#my $logFile = "/home/smariswa/TestLogs/getRoutingGeneral-1.log";
#open FILE, ">$logFile" or die "unable to open $logFile $!";


our @EXPORT = qw(

    parseConfFile

    peek

);





#

# Parses an Apache .conf file. Returns a data structure modeling the contents

# of the file.

#

# The data structure returned is a hash, mapping directive names to references to

# subordinate data structures. Let us refer to this hash as a type A data structure.

# The form of each subordinate data structure depends on the type of the associated

# directive. These may be:

#   1) A non-nesting directive with or without an argument. The resulting data structure

#      is a list of the values of all arguments to the directive, in the order

#      they appear in the configuration file. If the directive appears without

#      an argument, it is treated as thought it has an argument ''.

#   2) A nesting directive with an argument. The resulting data structure is a

#      hash mapping each argument value (argument values are assumed to be unqiue)

#      to a reference to a subordinate type A data structure. This subordinate

#      type A data structure represents the nested contents of the directive.

#   3) A nesting directive with no argument. The resulting data structure is a

#      list of references to subordinate type A data structures. Each subordinate

#      type A data structure represents the nested contents of a directive.

# Values of non-nesting directives are inherited by nested directives.

#

# Arguments:

#   0: The name of the configuration file to parse

#   1: A reference to a list of defined parameters.

#   2: A reference to a list of compiled-in modules. Each item should be in

#      the form "<module-name>.c".

#   3: Reference to a list that will get filled in with names of all included files.

#   4: Default server root directory

#

# Returns: A data structure modeling the configuration file, as described above.

#

sub parseConfFile

{

    #my $confFileName = $_[0];

#    my $definedParamsRef = $_[1];

#    my $compiledModulesRef = $_[2];

    my $serviceUrl = $_[0];

    my $mbeanObjectName = $_[1];

    my $userstring =  <STDIN>;

    my $passwordstring = <STDIN>;

    my @usertokens = split("UserName=",$userstring);

    my $username = $usertokens[1];

    my @passwordtokens = split("password=",$passwordstring);

    my $password = $passwordtokens[1];

#    my $defaultServerRoot = $_[4];



#    if (! -e $confFileName)

#    {

#        die "No such file: $confFileName";

#    }

     my @compiledModulesRef = ("mpm_worker_module","http_module","so_module","oralog_module","ora_audit_module", "plsql_module","perl_module","weblogic_module","ossl_module");

    my %modules;

    for my $mod (@compiledModulesRef)

    {

        if ($mod)

        {

            $modules{$mod} = 1;

        }

    }

    my @definedParams; #No params for As11 OHS

    my %defines;

    for my $def (@definedParams)

    {

        if ($def)

        {

            $defines{$def} = 1;

        }

    }

    

    my %rootHash;

    tie %rootHash, 'ias::Apache_confFileParser::LowerCaseHash';

    my @context;

    my %simpleHash;

    tie %simpleHash, 'ias::Apache_confFileParser::LowerCaseHash';



    #get httpd config files

    my $agentHome = $ENV{ORACLE_HOME};

	my $AGENT_PLUGIN_ROOT = $ENV{'PLUGIN_ROOT'};

    my $java = catfile($agentHome, 'jdk', 'bin', 'java');

    my $emdjavajar = catfile($AGENT_PLUGIN_ROOT, 'archives', 'jlib', 'emd_java.jar');

    my $wljmxclientjar = catfile($AGENT_PLUGIN_ROOT, 'archives', 'jlib', 'wljmxclient.jar');

    my $cpsep = ":";

    my $sep = "/";
    my $agentStateDir = $ENV{EMSTATE};
    my $oraHome = $ENV{EMDROOT};
    #my $agentTrust = $agentStateDir."/sysman/config/montrust/AgentTrust.jks";
    my $agentTrust = catfile($agentStateDir, "sysman", "config", "montrust", "AgentTrust.jks");
    my $trustStoreProps = "-Dssl.debug=false -Djavax.net.ssl.trustStore=$agentTrust -Dweblogic.security.TrustKeyStore=CustomTrust -Dweblogic.security.CustomTrustKeyStoreFileName=$agentTrust -Dweblogic.security.SSL.enforceConstraints=off -Dweblogic.security.SSL.ignoreHostnameVerification=true";
 
    my $wlfullclientjar = catfile($oraHome, 'sysman', 'jlib', 'wlfullclient.jar');
    my $webserviceclientssljar=catfile($oraHome, 'sysman', 'jlib', 'webserviceclient+ssl.jar');
    my $wlcipherjar=catfile($oraHome, 'sysman', 'jlib','wlcipher.jar');
    my $cryptojjar=catfile($oraHome, 'sysman', 'jlib','cryptoj.jar');

    my $wlcipherjar1 = catfile($AGENT_PLUGIN_ROOT, 'archives','jlib', 'wlcipher.jar');
    my $wlfullclientjar1 = catfile($AGENT_PLUGIN_ROOT, 'archives', 'jlib','wlfullclient.jar');
    my $wlthint3client = catfile($AGENT_PLUGIN_ROOT, 'archives', 'jlib','wlthint3client.jar');



    if(&IsWindows() ) {

	$cpsep = ";";

    }

    my $classpath = $emdjavajar ;
    if((-r  $wlfullclientjar) && (-r $webserviceclientssljar) && (-r $wlcipherjar)  && (-r $cryptojjar) ){
      $classpath = $classpath . $cpsep . $wlfullclientjar . $cpsep . $webserviceclientssljar .$cpsep . $wlcipherjar . $cpsep . $cryptojjar . $cpsep;
    }elsif((-r  $wlfullclientjar1) && (-r $wlcipherjar1)){
      $classpath = $classpath . $cpsep . $wlfullclientjar1 . $cpsep . $wlcipherjar1 . $cpsep;
    }else{
       $classpath =  $classpath . $cpsep . $wlthint3client . $cpsep;
    } 
    my $className = 'oracle.sysman.emas.model.ohs.ECMConfFiles';

    my $command = $java . ' ' . $trustStoreProps . ' -classpath ' . $classpath . ' ' . $className . ' ' . $serviceUrl . ' ' . $mbeanObjectName;

    #print FILE "Get File List Command : $command\n\n";
    #my @args = ($java,' -classpath ',$classpath,$className,$serviceUrl ,$mbeanObjectName);

    local (*HANDLE_IN, *HANDLE_OUT);

    my $pid =open3( \*HANDLE_IN, \*HANDLE_OUT, \*HANDLE_OUT, $command);

    print HANDLE_IN "UserName=$username";

    print HANDLE_IN "password=$password";

    my(@filesList) = <HANDLE_OUT>;



   #my $dmpStr = Dumper(@filesList);
   #print FILE "File List: $dmpStr";
    close(HANDLE_IN);

    close(HANDLE_OUT);



     #my $fileslList; # = `$command`;

    print "filesList=$filesList[0]\n";

    my @confFileNames = split(',',$filesList[0]);

    print @confFileNames;

    my @confFileContent;

     for my $confFileName (@confFileNames)

    {

    #my $confFileContent = fetchConfigFile($serviceUrl,$mbeanObjectName, 'getFileContents', $confFileName);

    $className = 'oracle.sysman.emas.model.webcache.RemoteConfigXmlUtil';

    $command = $java . ' ' . $trustStoreProps . ' -classpath ' . $classpath . ' ' . $className . ' ' . $serviceUrl . ' ' . $mbeanObjectName . ' ' . 'getFileContents'. ' ' . $confFileName;

    #print FILE "Get File Content Command:$command\n\n"; 
    my $pid =open3( \*HANDLE_IN, \*HANDLE_OUT, \*HANDLE_OUT, $command);

    print HANDLE_IN "UserName=$username";

    print HANDLE_IN "password=$password";

    @confFileContent  = <HANDLE_OUT>;

    close(HANDLE_IN);

    close(HANDLE_OUT);

    

    parseConfFileImpl($confFileName,

                      \%modules,

                      \%defines,

                      \%rootHash,

                      \%simpleHash,

                      \@context,

                      [] ,

                      \@confFileContent);

#                      $defaultServerRoot);

    }

    return \%rootHash;

}



sub parseConfFileImpl

{

    my $confFileName = $_[0];

    my $modulesRef = $_[1];

    my $definesRef = $_[2];

    my $hashRef = $_[3];

    my $simpleHashRef = $_[4];

    my $contextRef = $_[5];

    my $simpleContextRef = $_[6];

#   my $defaultServerRoot = $_[8];

    my $confFileContent = $_[7];

    my $serviceUrl = $_[8];

    my $mbeanObjectName = $_[9];    



#    if (defined($filesRef))

#    {

#        push(@{$filesRef}, $confFileName);

#    }



#    my $FILE;

#    open($FILE, $confFileName);

#    my @lines = readline($FILE);

#     my @lines = split(/\n/,$confFileContent);

#    close($FILE);

    my @lines =  @{$confFileContent};



    while (1)

    {

        my $line = nextLine(\@lines);

        if (length($line) == 0)

        {

            last;

        }

        if ($line =~ /^<\/(.*)>$/)

        {

            # directive is an end tag

            

            my $directive = lc($1);

            if ($directive ne 'ifmodule' && $directive ne 'ifdefine')

            {

                # Return to the context of the parent directive

                $hashRef = pop(@{$contextRef});

                $simpleHashRef = pop(@{$simpleContextRef});

            }

        }

        elsif ($line =~ /^<(.*)>$/)

        {

            # directive is a start tag

        

            my $directive = $1;

            my $argument;



            if ($directive =~ /^(\S*)\s+(.*)$/)

            {

                # directive is a start tag with arguments

                $directive = $1;

                $argument = $2;

            }



            $directive = lc($directive);

            

            if ($directive eq 'ifmodule')

            {

                my $neg = 0;

                if ($argument =~ /^!(.*)$/)

                {

                    $argument = $1;

                    $neg = 1;

                }

                my $shouldSkip = !$$modulesRef{$argument};

                if ($neg)

                {

                    $shouldSkip = !$shouldSkip;

                }

                if ($shouldSkip)

                {

                    skipToEndTag(\@lines, 'ifmodule');

                }

            }

            elsif ($directive eq 'ifdefine')

            {

                my $neg = 0;

                if ($argument =~ /^!(.*)$/)

                {

                    $argument = $1;

                    $neg = 1;

                }

                my $shouldSkip = !$$definesRef{$argument};

                if ($neg)

                {

                    $shouldSkip = !$shouldSkip;

                }

                if ($shouldSkip)

                {

                    skipToEndTag(\@lines, 'ifdefine');

                }

            }

            else

            {

                # The current context is either the top level of the file,

                # or some nesting directive. Call this the base context.

                # We are entering a new nesting directive, so we need to create

                # a new context.

                # Context is represented by two hash variables:

                # hashRef, which contains all directives, and simpleHashRef,

                # which contains only non-nesting directives to be inherited

                # by any child nesting directives.

                # We must create a new hashRef and simpleHashRef for the new

                # context. Both should be copies of simpleHashRef from the base

                # context.

                

                # Create one copy of the base simpleHashRef, which will become

                # the new hashRef.

                my %newHash;

                tie %newHash, 'ias::Apache_confFileParser::LowerCaseHash';

                %newHash = %{$simpleHashRef};



                # Store a reference to the new hash in the base hash.

                if (defined($argument))

                {

                    my $argHash = $$hashRef{$directive};

                    if ($argHash)

                    {

                        $$argHash{$argument} = \%newHash;

                    }

                    else

                    {

                        $argHash = { $argument => \%newHash };

                        $$hashRef{$directive} = $argHash;

                    }

                }

                else

                {

                    my $listRef = $$hashRef{$directive};

                    if ($listRef)

                    {

                        push(@{$listRef}, \%newHash);

                    }

                    else

                    {

                        $$hashRef{$directive} = [ \%newHash ];

                    }

                }

                

                # Save the base context for when we need to exit the new context.

                push(@{$contextRef}, $hashRef);

                push(@{$simpleContextRef}, $simpleHashRef);



                # Update hashRef for the new context.

                $hashRef = \%newHash;

                

                # Copy the base simpleHashRef again, and update simpleHashRef

                # for the new context.

                my %newHash1;

                tie %newHash1, 'ias::Apache_confFileParser::LowerCaseHash';

                %newHash1 = %{$simpleHashRef};

                $simpleHashRef = \%newHash1;

            }

        }

        elsif ($line =~ /^(\S+)\s+(.*)$/)

        {

            # directive is a simple directive with arguments

            

            my $directive = lc($1);

            my $argument = $2;



            # strip quotes from argument

            if ($argument =~ /^"(.*)"$/)

            {

                $argument = $1;

            }



            if ($directive eq 'loadmodule')

            {

                if ($argument =~ /^(\S+)_module\s/)

                {

                    my $moduleName = "mod_$1.c";

                    $$modulesRef{$moduleName} = 1;

                }

                else

                {

                    main::EMD_PERL_ERROR("Cannot parse line: '$line'");

                }

            }

            elsif ($directive eq 'addmodule')

            {

                $$modulesRef{$argument} = 1;

            }

            elsif ($directive eq 'include')

            {

                my $fileName = $argument;

                $fileName = split('\/',$fileName);

                #my $fileContent = fetchConfigFile($serviceUrl,$mbeanObjectName, 'getFileContents', $fileName);

                #if (!File::Spec->file_name_is_absolute($fileName))

                #{

                    # Include file path is relative

                    # Need to prepend the ServerRoot

                    # Look up the most recent ServerRoot directive, if any

                    #my $serverRoot = peek($$hashRef{'ServerRoot'});

                    #if (!defined($serverRoot))

                    #{

                    #    $serverRoot = $defaultServerRoot;

                    #}

                    #if (defined($serverRoot))

                    #{

                    #    $fileName = File::Spec->rel2abs($fileName, $serverRoot);

                    #}

                #}

                #if (-e $fileName)

                #{

                    #parseConfFileImpl($fileName,

                     #                 $modulesRef,

                      #                $definesRef,

                       #               $hashRef,

                        #              $simpleHashRef,

                         #             $contextRef,

                          #            $simpleContextRef,

                           #           $fileContent,

                            #          $serviceUrl,

                             #         $mbeanObjectName);

                                     # $defaultServerRoot);

                #}

                #else

                #{

                #    main::EMD_PERL_ERROR("Include file does not exist: '$fileName'");

                #}

            }

            else

            {

                my @list;

                my $oldListRef = $$hashRef{$directive};

                if ($oldListRef)

                {

                    push(@list, @{$oldListRef});

                }

                push(@list, $argument);

                $$hashRef{$directive} = \@list;

                $$simpleHashRef{$directive} = \@list;

            }

        }

        elsif ($line =~ /^(\S+)$/)

        {

            # directive is a simple directive with no arguments

            my $directive = lc($1);



            if ($directive eq 'clearmodulelist')

            {

                %{$modulesRef} = ();

            }

            else

            {

                my @list;

                my $oldListRef = $$hashRef{$directive};

                if ($oldListRef)

                {

                    push(@list, @{$oldListRef});

                }

                push(@list, '');

                $$hashRef{$directive} = \@list;

                $$simpleHashRef{$directive} = \@list;

            }

        }

        else

        {

            # unknown case

            main::EMD_PERL_ERROR("Cannot parse line: '$line'");

        }

    }

}



sub nextLine

{

    my $linesRef = $_[0];

    my $line = '';

    while (@{$linesRef} > 0)

    {

        $line = shift(@{$linesRef});



        # Trim comments

        if ($line =~ /^(.*?)\#.*$/)

        {

            $line = $1;

        }

        # Trim whitespace

        if ($line =~ /^\s*(.*?)\s*$/)

        {

            $line = $1;

        }

        # Skip blank lines

        if (length($line) == 0)

        {

            next;

        }

        last;

    }

    return $line;

}



sub skipToEndTag

{

    my $lines = $_[0];

    my $tagName = $_[1];

    my $depth = 1;

    my $re = qr/<$tagName\s.*>/;

    while ($depth > 0 && @{$lines} > 0)

    {

        my $line = lc(nextLine($lines));

        if ($line =~ $re)

        {

            $depth = $depth + 1;

        }

        if ($line eq "</$tagName>")

        {

            $depth = $depth - 1;

        }

    }

    if ($depth > 0)

    {

        main::EMD_PERL_ERROR("End tag not found: '$tagName'");

    }

}



#

# Returns the last item in an array.

#

# Arguments

#   0: A reference to an array, or undef.

#

# Returns: The last item in the array, or the default value if the array reference is not defined.

#

sub peek

{

    my $ref = $_[0];

    if (!defined($ref))

    {

        return undef;

    }

	

    return ($$ref[-1]);

}



sub IsWindows {

    my $osname = $^O;

    if (   $osname eq "Windows_NT"

        || $osname eq "MSWin32"

        || $osname eq "MSWin64" )

    {

        return 1;

    }

    else {

        return 0;

    }

}





return 1;

