# 
# $Header: emas/sysman/admin/scripts/ias.10g/AS11OHS_confFilesDumper.pm /main/2 2012/04/15 03:56:09 rahgupta Exp $
#
# 
# Copyright (c) 2004, 2012, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#     AS11OHS_confFilesDumper.pm 
#
#    DESCRIPTION
#	Uploads Apache Config Files
#
#      
#      Entry points:
#       writeConfigFiles
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    smariswa     02/09/12 - Remove unwanted code
#    smariswa     11/16/11 - Creation
# 


BEGIN
{
    require "emd_common.pl";
}

package ias::AS11OHS_confFilesDumper;

use strict;
use Exporter 'import';
use File::Spec;
use File::Path;
use ias::webtierConfig;
use File::Spec::Functions;
use IPC::Open3;
use IO::Handle;
use Data::Dumper;
#my $logFile = "/home/smariswa/Downloads/ConfigFileDumper.log";
#open FILE, ">$logFile" or die "unable to open $logFile $!";

our @EXPORT = qw(
    writeConfigFiles
);


sub writeConfigFiles
{

    my $serviceUrl = $_[0];
    my $mbeanObjectName = $_[1];
    my $targetDir = $_[2];
    my $userstring =  <STDIN>;
    my $passwordstring = <STDIN>;
    my @usertokens = split("UserName=",$userstring);
    my $username = $usertokens[1];
    my @passwordtokens = split("password=",$passwordstring);
    my $password = $passwordtokens[1];
    
    #get httpd config files
    my $agentHome = $ENV{ORACLE_HOME};
	my $AGENT_PLUGIN_ROOT = $ENV{'PLUGIN_ROOT'};
    my $java = catfile($agentHome, 'jdk', 'bin', 'java');
    my $emdjavajar = catfile($AGENT_PLUGIN_ROOT, 'archives', 'jlib', 'emd_java.jar');
    my $wljmxclientjar = catfile($AGENT_PLUGIN_ROOT, 'archives', 'jlib', 'wljmxclient.jar');
    my $cpsep = ":";
    my $agentStateDir = $ENV{EMSTATE};
    my $oraHome = $ENV{EMDROOT};
    my $agentTrust = catfile($agentStateDir, "sysman", "config", "montrust", "AgentTrust.jks");
    my $trustStoreProps = "-Dssl.debug=false -Djavax.net.ssl.trustStore=$agentTrust -Dweblogic.security.TrustKeyStore=CustomTrust -Dweblogic.security.CustomTrustKeyStoreFileName=$agentTrust -Dweblogic.security.SSL.enforceConstraints=off -Dweblogic.security.SSL.ignoreHostnameVerification=true";
 
    my $wlthint3client = catfile($AGENT_PLUGIN_ROOT, 'archives', 'jlib','wlthint3client.jar');

    if(&IsWindows() ) {
	$cpsep = ";";
    }
    my $classpath = $emdjavajar ;
    $classpath =  $classpath . $cpsep . $wlthint3client . $cpsep;


    my $className = 'oracle.sysman.emas.model.ohs.ECMConfFiles';
    my $command = $java . ' ' . $trustStoreProps . ' -classpath ' . $classpath . ' ' . $className . ' ' . $serviceUrl . ' ' . $mbeanObjectName;
    #print FILE "Get File List Command : $command\n\n";
    my @args = ($java,' -classpath ',$classpath,$className,$serviceUrl ,$mbeanObjectName);
    local (*HANDLE_IN, *HANDLE_OUT);
    my $pid =open3( \*HANDLE_IN, \*HANDLE_OUT, \*HANDLE_OUT, $command);
    print HANDLE_IN "UserName=$username";
    print HANDLE_IN "password=$password";
    my(@filesList) = <HANDLE_OUT>;

    #my $dmpStr = Dumper(@filesList);
    #print FILE "File List: $dmpStr";
    close(HANDLE_IN);
    close(HANDLE_OUT);

     #my $fileslList; # = `$command`;
    print "filesList=$filesList[0]\n";
    my @confFileNames = split(',',$filesList[0]);
    print @confFileNames;
    my @confFileContent;
     for my $confFileName (@confFileNames)
    {

    $className = 'oracle.sysman.emas.model.webcache.RemoteConfigXmlUtil';
    $command = $java . ' ' . $trustStoreProps . ' -classpath ' . $classpath . ' ' . $className . ' ' . $serviceUrl . ' ' . $mbeanObjectName . ' ' . 'getFileContents'. ' ' . $confFileName;
    #print FILE "Get File Content Command:$command\n\n"; 
    my $pid =open3( \*HANDLE_IN, \*HANDLE_OUT, \*HANDLE_OUT, $command);
    print HANDLE_IN "UserName=$username";
    print HANDLE_IN "password=$password";
    @confFileContent  = <HANDLE_OUT>;
    close(HANDLE_IN);
    close(HANDLE_OUT);
    
   # $dmpStr = Dumper(@confFileContent);
#    print FILE "File Content: $dmpStr";

    writeConfFileImpl($confFileName,  $targetDir,  \@confFileContent);
    }

    return 1;
}

sub writeConfFileImpl
{
    my $confFileName = $_[0];
    my $targetDir = $_[1];
    my $confFileContent = $_[2];
    my $fileName = catfile($targetDir, $confFileName);
    #print FILE "confFileName $fileName\n";
    mkpath $targetDir; 
    open CONF_FILE, ">$fileName" or die "unable to open $fileName $!";
    my @lines =  @{$confFileContent};
    while (1)
    {
        my $line = nextLine(\@lines);
        if (length($line) == 0)
        {
            last;
        }
        print CONF_FILE "$line\n";
    }
    #print FILE "Completed writing to $fileName\n";
    close(CONF_FILE);
}

sub nextLine
{
    my $linesRef = $_[0];
    my $line = '';
    while (@{$linesRef} > 0)
    {
        $line = shift(@{$linesRef});

        # Trim comments
        if ($line =~ /^(.*?)\#.*$/)
        {
            $line = $1;
        }
        # Trim whitespace
        if ($line =~ /^\s*(.*?)\s*$/)
        {
            $line = $1;
        }
        # Skip blank lines
        if (length($line) == 0)
        {
            next;
        }
        last;
    }
    return $line;
}


sub IsWindows {
    my $osname = $^O;
    if (   $osname eq "Windows_NT"
        || $osname eq "MSWin32"
        || $osname eq "MSWin64" )
    {
        return 1;
    }
    else {
        return 0;
    }
}


return 1;

