#!/usr/local/bin/perl
# 
# $Header: emas/sysman/admin/scripts/ias.10g/AS11OHS_getGeneral.pl /main/2 2012/02/02 22:32:15 ajamil Exp $
#
# Apache2_getGeneral.pl
# 
# Copyright (c) 2009, 2012, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      Apache2_getGeneral.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    rummadi     08/25/09 - Creation
#

use strict;
use ias::Apache_confFileParser;
use ias::asecm;
use File::Spec::Functions;

my $serviceUrl = $ARGV[0];
my $generalObjectName = $ARGV[1];
my $agentHome = $ENV{ORACLE_HOME};
    my $java = catfile($agentHome, 'jdk6', 'bin', 'java');
    my $emdjavajar = catfile($agentHome, 'sysman', 'jlib', 'emd_java.jar');
    my $wljmxclientjar = catfile($agentHome, 'sysman', 'jlib', 'wljmxclient.jar');
    my $psep;
    if(&IsWindows())
    {
		$psep = ";";
    }
    else
    {
		$psep = ":"; 
    }
    my $classpath = $emdjavajar . $psep . $wljmxclientjar; 
    my $className = 'oracle.sysman.emas.model.ohs.ECMGeneral';
    my $command = $java . ' -classpath ' . $classpath . ' ' . $className . ' ' . $serviceUrl . ' ' . $generalObjectName ;
     print `$command`;

    
sub IsWindows {
    my $osname = $^O;
    if (   $osname eq "Windows_NT"
        || $osname eq "MSWin32"
        || $osname eq "MSWin64" )
    {
        return 1;
    }
    else {
        return 0;
    }
}
         
