#!/usr/local/bin/perl
#
# $Header: emas/sysman/admin/scripts/ias.10g/Apache_RoutingInfo.pm /main/1 2012/06/08 09:59:31 smariswa Exp $
#
# Apache_getRoutingInfo.pl
#
# Copyright (c) 2009, 2012, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      Apache_getRoutingInfo.pl - Most of the code is copied from emas/sysman/admin/scripts/generic_apache/getRoutingInfo.pl
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    smariswa   05/25/12 - Creation
#
package ias::Apache_RoutingInfo;

use strict;
use Exporter 'import';
use ias::asecm;
use ias::simpleXPath;
use Data::Dumper;

require "emd_common.pl";
our @EXPORT = qw(
    parseRoutingGeneral
    parseRoutingLocations
);

############################### parseRoutingGeneral ##############################################
sub parseRoutingGeneral
{
	my $hash = $_[0];
	my $matchexpr = peek($$hash{'MatchExpression'});
	my $wlcluster = peek($$hash{'WebLogicCluster'});
	my $wlhost = peek($$hash{'WebLogicHost'});
	my $wlport = peek($$hash{'WebLogicPort'});
        my $wlIoTOS = peek($$hash{'WLIOTimeoutSecs'});
	my $ssl =  peek($$hash{'SecureProxy'});

	if(not defined $ssl ) {
            $ssl = "OFF";
        }
        $ssl = uc($ssl);
	#TODO: Add $ssl, 'string', for all printResult statements in handleMatchExpression
	if(defined ($matchexpr) ) {
            handleMatchExpression($matchexpr,"N/A",$wlcluster,$wlhost,$wlport,$wlIoTOS,$ssl);
	}

	my $vhosthash = $$hash{'VirtualHost'};
	#print Dumper($vhosts);

	if ($vhosthash) {
 	    my %hashRef  = %$vhosthash;
	    for my $vhostExpr (keys %hashRef) {
        	my $vhost = $vhostExpr;
		my $vhostHash = $hashRef{$vhostExpr};
                my $v_wlhost = peek($$vhostHash{'WebLogicHost'});
        	my $v_wlport = peek($$vhostHash{'WebLogicPort'});
	        my $v_wlcluster = peek($$vhostHash{'WebLogicCluster'});
    	        my $v_matchexpr = peek($$vhostHash{'MatchExpression'});
		my $v_wlIoTOS = peek($$vhostHash{'WLIOTimeoutSecs'});
		my $v_ssl =  peek($$vhostHash{'SecureProxy'});
		if(not defined $v_ssl) {
		    $v_ssl = "OFF";
		}
                $v_ssl = uc($v_ssl);
		if(defined ($matchexpr) ) {
    		    handleMatchExpression($v_matchexpr,$vhost,$v_wlcluster,$v_wlhost,$v_wlport,$v_wlIoTOS,$v_ssl);
		}
	    }
	}
}

################################### handleMatchExpression ##########################################
sub handleMatchExpression {

    my ($matchexpr,$vhost,$wlcluster,$wlhost,$wlport,$wlIoTOS,$ssl) = @_;  
    my $expr = $matchexpr;

    if($matchexpr =~ m/\s*?(\S+)\s+?/  ) {
        $expr = $1;
    }
    my $cluster4expr = "";
    if($matchexpr =~ m/WebLogicCluster=(\S+)\|/ ) {
        $cluster4expr = $1; #WebLogicCluster defined in MatchExpression line
	handleWebLogicCluster($cluster4expr,$vhost,$expr,$wlIoTOS,$ssl);
    }
    my $host4expr=""; #WebLogicHost defined in  MatchExpression line
    if($matchexpr =~ m/WebLogicHost=(\S+)\|/ ) {
        $host4expr = $1;
    }
    my $port4expr; #WebLogicPort defined in  MatchExpression line
    if($matchexpr =~ m/WebLogicPort=(\S+)\|/ ) {
        $port4expr = $1;
    }

    if( (defined $host4expr ) && (trim($host4expr) ne "") ) {
        printResult(
            $vhost,     'string',
            $host4expr, 'string',
            $port4expr, 'number',
            $cluster4expr, 'string',
            $expr,      'string',
	    $wlIoTOS,   'number',
            $ssl,       'string',
        );
    }

    if( (defined ($wlhost)) && (trim($host4expr) eq "")) {

	printResult(
		$vhost,     'string',
		$wlhost,    'string',
	    	$wlport,    'number',
	    	$wlcluster, 'string',
    		$expr,      'string',
		$wlIoTOS,   'number',
	    	$ssl,       'string'
	);
	}

	if( (defined ( $wlcluster )) && (trim($cluster4expr) eq "")) {
		handleWebLogicCluster($wlcluster,$vhost,$expr,$wlIoTOS,$ssl);
 	}

}  #end handleMatchExpression

################################## handleWebLogicCluster ###########################################
sub handleWebLogicCluster {
	my ($cluster,$vhost,$expr,$wlIoTOS,$ssl ) = @_;  
	my @hostporttokens = split(/,/,$cluster);

        foreach my $hostport (@hostporttokens) {
		my ($host,$port) = split(/:/,$hostport);
	        printResult(
		    $vhost,   'string',
	            $host,    'string',
		    $port,    'number',
	            $cluster,    'string',
		    $expr,    'string',
		    $wlIoTOS, 'number',
	            $ssl,     'string'
    		);
	}
}



################################## parseRoutingLocations ###########################################

sub parseRoutingLocations
{
        my $hash = $_[0];
	my $apacheHome =     peek($$hash{'ServerRoot'});

	#get WebLogic Locations
	my @wlRoutings = getWLRoutings($hash);
	#get Weblogic Locations in VirtualHost blocks
	my $vhostshash = $$hash{'VirtualHost'};

	if ($vhostshash) {
		my %hashRef  = %$vhostshash;
		for my $vhostExpr (keys %hashRef)
		{
		    my $vhost = $vhostExpr;
		    my $vhostHash = $hashRef{$vhostExpr};
		    my @wlRoutingsVh =  getWLRoutings($vhostHash);
		    my $loclen = scalar(@wlRoutingsVh);		  
		    for(my $j=0; $j < $loclen; $j++)
		    {
			my $val = $wlRoutingsVh[$j];
			my %loc= %$val;
			printResult(
				$vhost,                 'string',
				$loc{'appPath'},        'string',
				$loc{'host'},           'string',
				$loc{'port'},           'number',
				$loc{'cluster'},        'string',
				$loc{'wlIOTimeout'},    'number',
				$loc{'ssl'},           'string',
			);
		    }
		}
	}

	my $wllen = scalar(@wlRoutings);

	#EMD_PERL_DEBUG("No of Routings=$alllen");

	for(my $i=0; $i < $wllen; $i++)
	{
	    my $arrVal = $wlRoutings[$i];
	    my %location = %$arrVal;
	    printResult(
			'N/A',                         'string',
		        $location{'appPath'},        'string',
		        $location{'host'},           'string',
		        $location{'port'},           'number',
		        $location{'cluster'},        'string',
			$location{'wlIOTimeout'},    'number',
		        $location{'ssl'},            'string',
	    );
	}
}


################################## getWLRoutings ###########################################
sub getWLRoutings
{
    my @results;
    my $hashRef = @_[0];
    #EMD_PERL_DEBUG("getWLRoutings Entered");
    my @locs = getLocations($hashRef,"Location");
    #print Dumper (@locs);
    my $lenLocs = @locs;
    #EMD_PERL_DEBUG("Length of Locations Directive array=$lenLocs");

    push(@results,@locs);
    
    my @locsmatch = getLocations($hashRef,"LocationMatch");
    my $lenLocMatch = @locsmatch;
    #EMD_PERL_DEBUG("Length of LocationMatch Directive array=$lenLocMatch");
    push(@results,@locsmatch);
    
    my $ifModulesRef = $$hashRef{'IfModule'};
    #EMD_PERL_DEBUG("IfModulesRef=$ifModulesRef");
    
    return @results;
}

################################## getLocations ###########################################

sub getLocations
{
    my $hash = @_[0];
    my $pattern = @_[1];

    my @results;
    my $locs = $$hash{$pattern};
    #EMD_PERL_DEBUG("getLocations ********* $locs");
    
    if (!$locs){
        return ();
    }

    my $ssl =  peek($$hash{'SecureProxy'});
    if(not defined $ssl ) {
	$ssl = "OFF";
    }
    $ssl = uc($ssl);
    my %hashRef  = %$locs;

    for my $locExpr (keys %hashRef)
    {
        my $appPath = $locExpr;
        my $host;
        my $port;
	my $cluster;
	my $wlIoTOS;
        my $serverType = "weblogic_j2eeserver";
        my $serverName = "";

        my $locHash = $hashRef{$locExpr};
	my $handler = peek($$locHash{'SetHandler'});
	if('weblogic-handler' ne $handler) {
		next;
	}

        $host = peek($$locHash{'WebLogicHost'});
        $port = peek($$locHash{'WebLogicPort'});
	$cluster = peek($$locHash{'WebLogicCluster'});
	$wlIoTOS = peek($$locHash{'WLIOTimeoutSecs'});

	if( (defined $host) && ($host ne "") ){
            my $loc = {
 	        'appPath' => $appPath,
       	        'port' => $port,
           	'host' => $host,
		'cluster' => $cluster,
		'wlIOTimeout' => $wlIoTOS,
		'ssl' => $ssl
	    };
    	    push(@results, $loc);
	}

	if( (defined $cluster) && ($cluster ne "") ){
	    my @hostporttokens = split(/,/,$cluster);
	    foreach my $hostport (@hostporttokens) {
		my ($host,$port) = split(/:/,$hostport);
                my $loc = {
                    	'appPath' => $appPath,
                    	'port' => $port,
                    	'host' => $host,
                    	'cluster' => $cluster,
			'wlIOTimeout' => $wlIoTOS,
		 	'ssl' => $ssl
                };
                push(@results, $loc);
	    }
        }
    }

    return @results;
}

################################## trim ###########################################
sub trim($)
{
	my $string = shift;
	$string =~ s/^\s+//;
	$string =~ s/\s+$//;
	return $string;
}

################################## peek ###########################################

sub peek
{
    my $ref = $_[0];
    if (!defined($ref))
    {
        return undef;
    }

    return ($$ref[-1]);
}

