#!/usr/local/bin/perl
# 
# $Header: emas/sysman/admin/scripts/ias.10g/Apache_listConfigFiles.pl /main/1 2009/10/12 04:39:07 djoly Exp $
#
# Apache_listConfigFiles.pl
# 
# Copyright (c) 2004, 2009, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      Apache_listConfigFiles.pl - Apache ECM integration: list configuration files
#
#    DESCRIPTION
#      Command line utility called by the Agent to retrieve a list of configuration
#      files for Apache. Outputs the full path, size, and modification time of each
#      file (see statFiles in asecm.pm).
#
#      Implements the ConfigFileList metric defined in oracle_apache.xml.
#
#      Command-line arguments: <oracle home> <for upload flag> <target name>
#
#    NOTES
#
#    MODIFIED   (MM/DD/YY)
#    jsmoler     04/23/08 - Backport jsmoler_bug-6319688 from main
#    jsmoler     04/17/08 - filter duplicate include files
#    vaudinar    06/25/07 - location correction for ohs2.0
#    jsmoler     07/14/06 - use parseApacheConf (bug 5224028)
#    jsmoler     08/07/06 - Backport jsmoler_bug-5224028 from main
#    jsmoler     08/03/05 - collapse statFiles and restatFiles 
#    jsmoler     05/19/05 - dynamically determine root conf file 
#    jsmoler     01/10/05 - one more apache -> Apache 
#    jsmoler     12/16/04 - change paths to Apache 
#    jsmoler     10/25/04 - list all included .conf files 
#    jsmoler     10/04/04 - jsmoler_ecm01
#    jsmoler     08/18/04 - Creation
# 

use strict;
use ias::asecm;
use ias::Apache_confFileParser;

my $oracleHome = $ARGV[0];
setOracleHome($oracleHome);
my $forUploadStr = $ARGV[1];
my $forUpload = $forUploadStr eq 'true';
my $targetName = $ARGV[2];

if (! -d "$oracleHome/Apache")
{
statFiles(
    $forUpload,
    $targetName,

    'opmn/conf/opmn.xml',
#    'Apache/Jserv/etc/jserv.properties',
    'ohs/conf/mime.types',
);
}

else
{
statFiles(
    $forUpload,
    $targetName,

    'opmn/conf/opmn.xml',
    'Apache/Jserv/etc/jserv.properties',
    'Apache/Apache/conf/mime.types',
);
}

my @confFiles;
parseApacheConf(\@confFiles);
my %seen;
for my $confFile (@confFiles)
{
    if (!defined($seen{$confFile}))
    {
        statFile($confFile, $forUpload, $targetName);
    }
    $seen{$confFile} = 1;
}
