#!/usr/local/bin/perl
# 
# $Header: emas/sysman/admin/scripts/ias.10g/OC4J_getPasswordIndirection.pl /main/1 2009/10/12 04:39:07 djoly Exp $
#
# OC4J_getPasswordIndirection.pl
# 
# Copyright (c) 2005, 2009, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      OC4J_getPasswordIndirection.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    rkuriako    05/25/05 - bug-4370045
#    rkuriako    05/03/05 - bug-4188709
#    akmahesh    01/28/05 - akmahesh_policy_dev_ias
#    rkuriako    01/24/05 - Creation
# 


use strict;
use ias::simpleXPath;
use ias::asecm;

my $oracleHome = $ARGV[0];
setOracleHome($oracleHome);
my $instanceName = $ARGV[1];

#for rmi.xml
if (-e "$oracleHome/j2ee/$instanceName/config/rmi.xml")
{
	checkPwdIndirection("rmi.xml", "rmi-server/cluster","cluster");

}

# for jms.xml, check all 6 elements which support password indirection

if (-e "$oracleHome/j2ee/$instanceName/config/jms.xml")
{
	checkPwdIndirection("jms.xml", "jms-server/connection-factory","connection-factory");

	checkPwdIndirection("jms.xml", "jms-server/queue-connection-factory","queue-connection-factory");

	checkPwdIndirection("jms.xml", "jms-server/topic-connection-factory","topic-connection-factory");

	checkPwdIndirection("jms.xml", "jms-server/xa-connection-factory","xa-connection-factory");

	checkPwdIndirection("jms.xml", "jms-server/xa-queue-connection-factory","xa-queue-connection-factory");

	checkPwdIndirection("jms.xml", "jms-server/xa-topic-connection-factory","xa-topic-connection-factory");
}


# for application.xml

if (-e "$oracleHome/j2ee/$instanceName/config/application.xml")
{
	# 1. commit-coordinator
	 checkPwdIndirection("application.xml", "orion-application/commit-coordinator/property","commit-coordinator");

	# 2. resource-provider
	 checkPwdIndirection("application.xml", "orion-application/resource-provider/property","resource-provider");
}

# for internal-settings.xml

if (-e "$oracleHome/j2ee/$instanceName/config/internal-settings.xml")
{
	 checkPwdIndirection("internal-settings.xml", "internal-settings/server-extension-provider/sep-property","sep-property");
}


# for data-sources.xml

if (-e "$oracleHome/j2ee/$instanceName/config/data-sources.xml")
{
 	checkPwdIndirection("data-sources.xml", "data-sources/data-source","data-source");
}

#
# Performs a check on the file name and invoke the correct method for verifying
# password indirection status.
#
# Arguments:
#   0: XML file name
#   1: XPath query string
#   2: Name of the element which support passowrd indirection
#


sub checkPwdIndirection()
{
		
	my($filename, $queryPath, $elementName) = @_ ;

	my @results = simpleXPathQuery("$oracleHome/j2ee/$instanceName/config/$filename",$queryPath);
	
	my $counter = 1;
	
	for my $resultRef (@results)
	{
	   	if( ( $filename eq  "jms.xml" ) | ( $filename eq  "rmi.xml" ) )
		{
			my $password = $$resultRef{'password'};
          
			printMetricDetails($elementName."_$counter", $password, $filename);
		}
		elsif( $filename eq  "application.xml" )
		{
			 checkApplicationsPwd($resultRef, $elementName."_$counter", $filename);
	
		}
		elsif( $filename eq  "internal-settings.xml" )
		{
			 checkInternalSettingsPwd($resultRef, $elementName."_$counter", $filename);
	
		}
		elsif( $filename eq  "data-sources.xml" )
		{
			 checkDataSourcesPwd($resultRef, $elementName."_$counter", $filename);
	
		}
	
		$counter += 1;

	}#end for loop

	
}#end sub

#
# Retrieve the necessary attributes to check  password indirection for data-sources.xml.
# And invoke method to check password indirection status.
#
#
# Arguments:
#   0: Array element from Xpath query result
#   1: Name of the element which support password indirection
#   2: XML file name


sub checkDataSourcesPwd
{
	my($resultRef, $elementName, $filename) = @_ ;

	my $dsName  = $$resultRef{'name'};
	my $password    = $$resultRef{'password'};
	
	printMetricDetails($elementName." ".$dsName, $password, $filename);
} # end checkInternalSettingsPwd

#
# Retrieve the necessary attributes to check  password indirection for
# internal-settings.xml. And invoke method to check password indirection status.
#
# Arguments:
#   0: Array element from Xpath query result
#   1: Name of the element which support password indirection
#   2: XML file name

sub checkInternalSettingsPwd
{
	my($resultRef, $elementName, $filename) = @_ ;

	my $sepName  = $$resultRef{'name'};
	my $password    = $$resultRef{'value'};

	if ( ($sepName eq "keystore-password") | ($sepName eq "truststore-password") )
	{
		printMetricDetails($elementName, $password, $filename);

	} #end  $sepName  check

} # end checkInternalSettingsPwd

#
# Retrieve the necessary attributes to check  password indirection for applications.xml.
# And invoke method to check password indirection status.
#
# Arguments:
#   0: Array element from Xpath query result
#   1: Name of the element which support password indirection
#   2: XML file name

sub checkApplicationsPwd
{
	my($resultRef, $elementName, $filename) = @_ ;

	my $propName  = $$resultRef{'name'};
	my $password    = $$resultRef{'value'};

	if ( ($propName eq "password") )
	{
		printMetricDetails($elementName, $password, $filename);
	
	} #end $propName  check


} #end checkApplicationsPwd

#
# Performs  password indirection check and print the element name, status and filename
# if password indirection is off.
#
# Arguments:
#   0: Name of the element which support password indirection
#   1: Value of password attribute
#   2: XML file name


sub printMetricDetails
{
	my($elementName, $password, $filename) = @_ ;

	 if( ! ( $password eq "" ) )
	 {

		if(! (($password =~ m/^->/) & ( ! ($password =~ m/^->!->/))) )
		{
			$password = "off";
			
			printResult(
       			$elementName,            'string',
		        $password,               'string',
        		$filename,               'string',
			);
		}
		else
	        {
                        $password = "on";

                        printResult(
                        $elementName,            'string',
                        $password,               'string',
                        $filename,               'string',
                        );
        	}


     
  	  }#end $password empty check

}#end printMetricDetails


