#!/usr/local/bin/perl
# 
# $Header: emas/sysman/admin/scripts/ias.10g/OC4J_getPortRanges.pl /main/1 2009/10/12 04:39:07 djoly Exp $
#
# OC4J_getPortRanges.pl
# 
# Copyright (c) 2004, 2009, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      OC4J_getPortRanges.pl - OC4J ECM integration: get port ranges
#
#    DESCRIPTION
#      Command-line utility called by the Agent to retrieve port ranges
#      configured for an OC4J instance.
#
#      Implements the PortRanges metric defined in oc4j.xml.
#
#      Command-line arguments: <oracle home> <instance name>
#
#    NOTES
#
#    MODIFIED   (MM/DD/YY)
#    jsmoler     08/07/06 - Backport jsmoler_bug-5295826 from
#                           st_emasgc_10.2.0.1.0
#    jsmoler     06/27/06 - use new output functions 
#    jsmoler     11/23/05 - support 10.1.3 
#    jsmoler     10/04/04 - jsmoler_ecm01
#    jsmoler     08/26/04 - Creation
# 

use strict;
use ias::simpleXPath;
use ias::asecm;

my $oracleHome = $ARGV[0];
setOracleHome($oracleHome);
my $instanceName = $ARGV[1];

# Metric: PortRanges
setMetricFormat(
    { 'type' => 'string', 'key' => 1 }, # ID
    { 'type' => 'string' },             # range
);

my @results = simpleXPathQuery(
    "$oracleHome/opmn/conf/opmn.xml",
    'opmn//process-type[@module-id="OC4J"][@id="' . $instanceName . '"]/port'
);

my %protocolHash;
for my $result (@results)
{
    my $protocol = $$result{'protocol'};
    if (defined($protocol))
    {
        my $current = $protocolHash{$protocol};
        if (defined($current))
        {
            $current = $current . ',' . $$result{'range'}
        }
        else
        {
            $current = $$result{'range'};
        }
        $protocolHash{$protocol} = $current;
    }
    else
    {
        $protocolHash{$$result{'id'}} = $$result{'range'};
    }
}
for my $protocol (keys %protocolHash)
{
    printMetricResult(
        $protocol,
        $protocolHash{$protocol},
    );
}
