#!/usr/local/bin/perl
# 
# $Header: emas/sysman/admin/scripts/ias.10g/OC4J_getWebModuleSettings.pl /main/1 2009/10/12 04:39:07 djoly Exp $
#
# OC4J_getWebModuleSettings.pl
# 
# Copyright (c) 2004, 2009, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      OC4J_getWebModuleSettings.pl - OC4J ECM integration: get web module settings
#
#    DESCRIPTION
#      Command-line utility called by the Agent to retrieve a list web module
#      settings for an OC4J instance.
#
#      Implements the WebModuleSettings metric defined in oc4j.xml.
#
#      Command-line arguments: <oracle home> <instance name> <version category>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    jsmoler     08/07/06 - Backport jsmoler_bug-5295826 from
#                           st_emasgc_10.2.0.1.0
#    jsmoler     06/27/06 - use new output functions 
#    jsmoler     12/23/05 - support system app for 10.1.3 
#    jsmoler     03/08/05 - default value for distributable 
#    jsmoler     10/20/04 - update
#    jsmoler     10/04/04 - jsmoler_ecm01
#    jsmoler     09/10/04 - Creation
# 

use strict;
use ias::asecm;
use ias::simpleXPath;

my $oracleHome = $ARGV[0];
setOracleHome($oracleHome);
my $instanceName = $ARGV[1];
my $versionCategory = $ARGV[2];

# Metric: WebModuleSettings
setMetricFormat(
    { 'type' => 'string', 'key' => 1 }, # application name
    { 'type' => 'string', 'key' => 1 }, # module name
    { 'type' => 'string' },             # JSP mode
    { 'type' => 'number' },             # session timeout
    { 'type' => 'number' },             # distributable
);

my %globalInfo = parseWebAppInfo("$oracleHome/j2ee/$instanceName/config/global-web-application.xml");

my @modules = listOC4JModules($instanceName, $versionCategory);
for my $moduleRef (@modules)
{
    if ($$moduleRef{'type'} ne 'web')
    {
        next;
    }
    my $appName = $$moduleRef{'appName'};
    my $moduleName = $$moduleRef{'name'};
    my $moduleDir = "$oracleHome/j2ee/$instanceName/application-deployments/$appName/$moduleName";
    
    my %orionWebInfo = parseWebAppInfo("$moduleDir/orion-web.xml");
    my %webInfo = parseWebAppInfo("$moduleDir/web.xml");
    
    my %info = collapse(\%orionWebInfo, \%webInfo, \%globalInfo);
    
    my $distributable = $info{'distributable'};
    if (!defined($distributable))
    {
        $distributable = 0;
    }
    
    printMetricResult(
        $appName,
        $moduleName,
        $info{'jspMode'},
        $info{'sessionTimeout'},
        $distributable,
    );
}

sub collapse
{
    my %hash;
    
    for my $hashRef (@_)
    {
        for my $key (keys %{$hashRef})
        {
            if (!defined($hash{$key}))
            {
                $hash{$key} = $$hashRef{$key};
            }
        }
    }
    
    return %hash;
}
