#!/usr/local/bin/perl
# 
# $Header: emas/sysman/admin/scripts/ias.10g/OC4J_listConfigFiles.pl /main/1 2009/10/12 04:39:07 djoly Exp $
#
# OC4J_listConfigFiles.pl
# 
# Copyright (c) 2004, 2009, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      OC4J_listConfigFiles.pl - OC4J ECM integration: list configuration files
#
#    DESCRIPTION
#      Command line utility called by the Agent to retrieve a list of configuration
#      files for OC4J. Outputs the full path, size, and modification time of each
#      file (see statFiles in asecm.pm).
#
#      Implements the ConfigFileList metric defined in oc4j.xml.
#
#      Command-line arguments: <oracle home> <for upload flag> <target name> <OC4J instance name>
#
#    NOTES
#
#    MODIFIED   (MM/DD/YY)
#    jsmoler     08/21/08 - add more file types
#    jsmoler     11/01/05 - XbranchMerge jsmoler_bug-4613189 from main 
#    jsmoler     09/30/05 - don't follow links on NT
#    jsmoler     08/03/05 - collapse statFiles and restatFiles 
#    klmichae    06/20/05 - only include container files 
#    jsmoler     11/03/04 - 
#    jsmoler     10/20/04 - add more extensions 
#    jsmoler     10/04/04 - jsmoler_ecm01
#    jsmoler     09/10/04 - Creation
# 

use strict;
use ias::asecm;
use File::Find;
use File::stat;

my $oracleHome = $ARGV[0];
setOracleHome($oracleHome);
my $forUploadStr = $ARGV[1];
my $forUpload = $forUploadStr eq 'true';
my $targetName = $ARGV[2];
my $instanceName = $ARGV[3];


# the Agent can only currently handle UTF-8 files (see bug 4440803).  Until
# the restriction is removed, we will only include OC4J container configuration
# files in the file list.  We will not include any application files in this
# list
#my @subDirs = ( 'config', 'applications', 'application-deployments' );
my @subDirs = ( 'config' );
my @extensions = ( 'xml', 'properties', 'ear', 'war', 'rar', 'policy', 'types' );

for my $subDir (@subDirs)
{
    find({
        wanted => sub
        {
            for my $ext (@extensions)
            {
                if ($_ =~ /\.$ext$/)
                {
                    statFile($File::Find::name, $forUpload, $targetName, $instanceName);
                }
            }
        },
        follow => (getPlatform() eq 'unix'), # follow links
        follow_skip => 2 # if the same file is visited twice, skip it the second time
    },
    "$oracleHome/j2ee/$instanceName/$subDir");
}
