#!/usr/local/bin/perl
# 
# $Header: emas/sysman/admin/scripts/ias.10g/OC4J_listModules.pl /main/1 2009/10/12 04:39:07 djoly Exp $
#
# OC4J_listModules.pl
# 
# Copyright (c) 2004, 2009, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      OC4J_listModules.pl - OC4J ECM integration: list modules
#
#    DESCRIPTION
#      Command-line utility called by the Agent to retrieve a list of modules
#      for an OC4J instance. For each module, includes the parent application
#      name, module name, and module type (see listOC4JModules in asecm.pm).
#
#      Implements the Modules metric defined in oc4j.xml.
#
#      Command-line arguments: <oracle home> <instance name> <version category>
#
#    NOTES
#
#    MODIFIED   (MM/DD/YY)
#    jsmoler     08/07/06 - Backport jsmoler_bug-5295826 from
#                           st_emasgc_10.2.0.1.0
#    jsmoler     06/27/06 - use new output functions 
#    jsmoler     12/23/05 - support system app for 10.1.3 
#    jsmoler     10/04/04 - jsmoler_ecm01
#    jsmoler     08/02/04 - Creation
# 

use strict;
use ias::asecm;

my $oracleHome = $ARGV[0];
setOracleHome($oracleHome);
my $instanceName = $ARGV[1];
my $versionCategory = $ARGV[2];

# Metric: Modules
setMetricFormat(
    { 'type' => 'string', 'key' => 1 }, # application name
    { 'type' => 'string', 'key' => 1 }, # module name
    { 'type' => 'string', 'key' => 1 }, # module type
);

my @modules = listOC4JModules($instanceName, $versionCategory);

for my $moduleRef (@modules)
{
    printMetricResult(
        $$moduleRef{'appName'},
        $$moduleRef{'name'},
        $$moduleRef{'type'},
    );
}
