#!/usr/local/bin/perl
# 
# $Header: emas/sysman/admin/scripts/ias.10g/WebCache_getHostMappings.pl /main/2 2010/12/07 22:48:40 jsmoler Exp $
#
# WebCache_getHostMappings.pl
# 
# Copyright (c) 2004, 2010, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      WebCache_getHostMappings.pl - WebCache ECM integration: get host mappings
#
#    DESCRIPTION
#      Command-line utility called by the Agent to retrieve a list of mappings from
#      site to host.
#
#      Implements the SiteMappings metric defined in oracle_webcache.xml.
#
#      Command-line arguments: <oracle home>
#
#    NOTES
#
#    MODIFIED   (MM/DD/YY)
#    jsmoler     11/10/10 - parse file once
#    jsmoler     08/07/06 - Backport jsmoler_bug-5295826 from
#                           st_emasgc_10.2.0.1.0
#    jsmoler     06/26/06 - use new output functions 
#    jsmoler     10/04/04 - jsmoler_ecm01
#    jsmoler     08/27/04 - Creation
# 

use strict;
use ias::asecm;
use ias::simpleXPath;

my $oracleHome = $ARGV[0];
setOracleHome($oracleHome);

# Metric: SiteMappings
setMetricFormat(
    { 'type' => 'string', 'key' => 1 }, # site name
    { 'type' => 'string', 'key' => 1 }, # site port
    { 'type' => 'string', 'key' => 1 }, # site URL
    { 'type' => 'string', 'key' => 1 }, # host name
    { 'type' => 'number', 'key' => 1 }, # host port
);

my $fileRoot = ias::simpleXPath::parseFile("$oracleHome/webcache/webcache.xml");
my @mappings = ias::simpleXPath::queryForNodes($fileRoot, 'CALYPSO/GENERAL/VIRTUALHOSTMAP');

for my $mapping (@mappings)
{
    my $siteName = ias::simpleXPath::getAttribute($mapping, 'NAME');
    my $sitePort = ias::simpleXPath::getAttribute($mapping, 'PORT');
    my $siteURL = ensureSlash(ias::simpleXPath::getAttribute($mapping, 'URL'));

    my @hostrefs = ias::simpleXPath::queryForAttributes($mapping, 'VIRTUALHOSTMAP/HOSTREF');

    for my $hostref (@hostrefs)
    {
        my $hostID = $$hostref{'HOSTID'};
        
        my $host = (ias::simpleXPath::queryForAttributes($fileRoot,
                                                         'CALYPSO/GENERAL/HOST[@ID="' . $hostID . '"]'))[0];
        
        printMetricResult(
            $siteName,
            $sitePort,
            $siteURL,
            $$host{'NAME'},
            $$host{'PORT'},
        );
    }
}
