#!/usr/local/bin/perl
# 
# $Header: emas/sysman/admin/scripts/ias.10g/WebCache_getHostMappings_jmx.pl /main/1 2009/10/12 04:39:07 djoly Exp $
#
# WebCache_getHostMappings.pl
# 
# Copyright (c) 2004, 2009, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      WebCache_getHostMappings.pl - WebCache ECM integration: get host mappings
#
#    DESCRIPTION
#      Command-line utility called by the Agent to retrieve a list of mappings from
#      site to host.
#
#      Implements the SiteMappings metric defined in oracle_webcache.xml.
#
#      Command-line arguments: <oracle home>
#
#    NOTES
#
#    MODIFIED   (MM/DD/YY)
#    jsmoler     08/07/06 - Backport jsmoler_bug-5295826 from
#                           st_emasgc_10.2.0.1.0
#    jsmoler     06/26/06 - use new output functions 
#    jsmoler     10/04/04 - jsmoler_ecm01
#    jsmoler     08/27/04 - Creation
# 

use strict;
use ias::asecm;
use ias::simpleXPath;
use ias::webtierConfig;

my $xmlString = fetchConfigFile($ARGV[0], $ARGV[1], 'getFileContents', 'webcache.xml');

# Metric: SiteMappings
setMetricFormat(
    { 'type' => 'string', 'key' => 1 }, # site name
    { 'type' => 'string', 'key' => 1 }, # site port
    { 'type' => 'string', 'key' => 1 }, # site URL
    { 'type' => 'string', 'key' => 1 }, # host name
    { 'type' => 'number', 'key' => 1 }, # host port
);

my @mappings = simpleXPathQuery($xmlString,
                                'CALYPSO/GENERAL/VIRTUALHOSTMAP', 'string-type');

for my $mapping (@mappings)
{
    my $siteName = ensuredef($$mapping{'NAME'});
    my $sitePort = ensuredef($$mapping{'PORT'});
    my $siteURL = ensureSlash($$mapping{'URL'});

    my @hostrefs = simpleXPathQuery($xmlString,
                                    'CALYPSO/GENERAL/VIRTUALHOSTMAP[@NAME="' . $siteName . '"][@PORT="' . $sitePort . '"]/HOSTREF', 'string-type');
    for my $hostref (@hostrefs)
    {
        my $hostID = $$hostref{'HOSTID'};
        
        my $host = (simpleXPathQuery($xmlString,
                                     'CALYPSO/GENERAL/HOST[@ID="' . $hostID . '"]', 'string-type'))[0];
        
        printMetricResult(
            $siteName,
            $sitePort,
            $siteURL,
            $$host{'NAME'},
            $$host{'PORT'},
        );
    }
}
