#!/usr/local/bin/perl
# 
# $Header: emas/sysman/admin/scripts/ias.10g/WebCache_getSiteAliases_jmx.pl /main/2 2009/11/24 22:12:35 skotha Exp $
#
# WebCache_getSiteAliases.pl
# 
# Copyright (c) 2004, 2009, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      WebCache_getSiteAliases.pl - WebCache ECM integration: get site aliases
#
#    DESCRIPTION
#      Command-line utility called by the Agent to retrieve a list of site aliases.
#
#      Implements the SiteAliases metric defined in oracle_webcache.xml.
#
#      Command-line arguments: <oracle home>
#
#    NOTES
#
#    MODIFIED   (MM/DD/YY)
#    skotha      08/23/09 - Creation
# 

use strict;
use ias::asecm;
use ias::simpleXPath;
use ias::webtierConfig;

my $xmlString = fetchConfigFile($ARGV[0], $ARGV[1], 'getFileContents', 'webcache.xml');

# Metric: SiteAliases
setMetricFormat(
    { 'type' => 'string', 'key' => 1 }, # site name
    { 'type' => 'number', 'key' => 1 }, # site port
    { 'type' => 'string', 'key' => 1 }, # site URL
    { 'type' => 'string', 'key' => 1 }, # alias name
    { 'type' => 'number', 'key' => 1 }, # alias port
    { 'type' => 'string', 'key' => 0 }, # alias URL
);

my @sites = simpleXPathQuery($xmlString,
                            'CALYPSO/GENERAL/SITE', 'string-type');

for my $site (@sites)
{
    my $siteName = ensuredef($$site{'NAME'});
    my $sitePort = ensuredef($$site{'PORT'});
    my $siteURL = ensureSlash($$site{'URL'});

    my @aliases = simpleXPathQuery($xmlString,
                                   'CALYPSO/GENERAL/SITE[@NAME="' . $siteName . '"][@PORT="' . $sitePort . '"]/ALIAS', 'string-type');
    for my $alias (@aliases)
    {
        my $aliasURL = ensureSlash($$alias{'URL'});
        printMetricResult(
            $siteName,
            $sitePort,
            $siteURL,
            $$alias{'NAME'},
            $$alias{'PORT'},
            $aliasURL,
        );
    }
}
