#!/usr/local/bin/perl
# 
# $Header: emas/sysman/admin/scripts/ias.10g/WebCache_getSpecialPorts_jmx.pl /main/1 2009/10/12 04:39:07 djoly Exp $
#
# WebCache_getSpecialPorts_jmx.pl
# 
# Copyright (c) 2004, 2009, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      WebCache_getSpecialPorts_jmx.pl - WebCache ECM integration: get special ports
#
#    DESCRIPTION
#      Command-line utility called by the Agent to retrieve the values of the
#      administration, invalidation, and statistics ports.
#
#      Implements the OperationPorts metric defined in oracle_webcache.xml.
#
#      Command-line arguments: <oracle home> <host name>
#
#    NOTES
#
#    MODIFIED   (MM/DD/YY)
#    skotha      08/23/09 - Creation
# 

use strict;
use ias::asecm;
use ias::simpleXPath;
use ias::webtierConfig;

my $xmlString = fetchConfigFile($ARGV[0], $ARGV[1], 'getFileContents', 'webcache.xml');

setOracleHome($ARGV[2]);
my $hostName = $ARGV[3];

# Metric: OperationPorts
setMetricFormat(
    { 'type' => 'string', 'key' => 1 }, # type
    { 'type' => 'string' },             # IP
    { 'type' => 'number' },             # port
    { 'type' => 'string' },             # protocol
);

my $cacheName = getMyCache($hostName, $xmlString, 'string-type');

my @results = simpleXPathQuery($xmlString,
                               'CALYPSO/CACHE[@NAME="' . $cacheName . '"]/MULTIPORT/LISTEN', 'string-type');

for my $result (@results)
{
    my $portType = $$result{'PORTTYPE'};
    if ($portType ne 'NORM')
    {
        my $ip = getListenIP($$result{'IPADDR'});
        my $protocol = getListenProtocol($$result{'SSLENABLED'});
        printMetricResult(
            $portType,
            $ip,
            $$result{'PORT'},
            $protocol,
        );
    }
}
