#!/usr/local/bin/perl
# 
# $Header: listProcessFiles.pl 
#
# listProcessFiles.pl
# 
# Copyright (c) 2004, 2009, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      listProcessFiles.pl- BPEL PM ECM integration: list configuration files
#
#    DESCRIPTION
#      Command line utility called by the Agent to retrieve a list of configuration
#      files for Apache. Outputs the full path, size, and modification time of each
#      file (see statFiles in asecm.pm).
#
#      Implements the ConfigFileList metric defined in oracle_apache.xml.
#
#      Command-line arguments: <oracle home> <for upload flag> <target name>
#
#    NOTES
#
#    MODIFIED   (MM/DD/YY)
#       kotkumar 07/27/07 - Updating for BPEL 10.1.2
#       rsaraswa 07/10/07 - Adding XSD files


use strict;
use ias::asecm;
use ias::bpel::confFileParser;

my $oracleHome = $ARGV[0];
ias::asecm::setOracleHome($oracleHome);
my $forUploadStr = $ARGV[1];
my $forUpload = $forUploadStr eq 'true';
my $targetName = $ARGV[2];
my $bpelDomainHome;

if(-e  "$oracleHome/bpel/domains")
{	
	$bpelDomainHome = "$oracleHome/bpel/domains";
}else {		
	$bpelDomainHome = "$oracleHome/integration/orabpel/domains"; 	

}

opendir(DIR,"$bpelDomainHome");
my @domains = readdir(DIR);
closedir(DIR);
for my $domain (@domains) {

opendir(DIR1,"$bpelDomainHome/$domain/tmp");
my @procdirs = readdir(DIR1);
closedir(DIR1);
for my $procdir (@procdirs) 
{
if ($procdir eq ".") { next;}
if ($procdir eq "..") {next;}
if ($procdir eq ".generated") {next;}
my $proc;
    if($procdir =~ /^\.bpel_(\w+)_.+/) {
      $proc = $1;
      print "$proc\n";
     }
   opendir(PROCDIR,"$bpelDomainHome/$domain/tmp/$procdir");
   my $name;
   foreach $name(readdir PROCDIR) {
        if( $name =~ /^_/) {
		next;
        }
	if($name =~ /\.wsdl$/  || $name =~ /\.xsd$/ ) {

   ias::asecm::statFile("$bpelDomainHome/$domain/tmp/$procdir/$name", $forUpload, $targetName);
	}
   }
   closedir(PROCDIR);
   ias::asecm::statFile("$bpelDomainHome/$domain/tmp/$procdir/$proc.bpel", $forUpload, $targetName);
   ias::asecm::statFile("$bpelDomainHome/$domain/tmp/$procdir/bpel.xml", $forUpload, $targetName);

} #end procdirs
} # end domains
