#!/usr/local/bin/perl
# 
# $Header: emas/sysman/admin/scripts/ias.10g/dip/getDIPConfigDetail.pl /main/3 2010/03/08 21:13:59 proxy Exp $
#
# getDIPConfigDetail.pl
# 
# Copyright (c) 2009, 2010, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      getDIPConfigDetail.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    proxy       10/13/09 - fix_bug_9003955
#    proxy       07/16/09 - dip_config_collection
#    proxy       07/16/09 - Creation
# 

use strict;
use ias::simpleXPath;
use ias::asecm;
my $domainHome = $ARGV[0];

my $xmlFile; 

if(-e "$domainHome/servers/wls_ods1/stage/DIP/11.1.1.1.0/DIP/configuration/dip-config.xml"){
	$xmlFile = "$domainHome/servers/wls_ods1/stage/DIP/11.1.1.1.0/DIP/configuration/dip-config.xml";
}
elsif(-e "$domainHome/config/fmwconfig/servers/wls_ods1/applications/DIP_11.1.1.2.0/configuration/dip-config.xml"){
	$xmlFile = "$domainHome/config/fmwconfig/servers/wls_ods1/applications/DIP_11.1.1.2.0/configuration/dip-config.xml";
}
elsif(-e "$domainHome/config/fmwconfig/servers/wls_ods1/applications/DIP_11.1.1.3.0/configuration/dip-config.xml"){
        $xmlFile = "$domainHome/config/fmwconfig/servers/wls_ods1/applications/DIP_11.1.1.3.0/configuration/dip-config.xml";
}

my @oid;
@oid = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'DIPConfig/OID_NODE_HOST');
my $oidNodeHost = $oid[0];
@oid = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'DIPConfig/OID_NODE_PORT');
my $oidNodePort = $oid[0];
@oid = ias::simpleXPath::simpleXPathQueryForText($xmlFile, 'DIPConfig/REFRESH_INTERVAL');
my $refreshInterval = $oid[0];
@oid = ias::simpleXPath::simpleXPathQueryForText($xmlFile, 'DIPConfig/SSL_MODE');
my $sslMode = $oid[0];

ias::asecm::printResult(
     $oidNodeHost,      'string',
     $oidNodePort,    'string',
     $sslMode,   'number',
     $refreshInterval,   'number',
);
