#!/usr/local/bin/perl
# 
# $Header: emas/sysman/admin/scripts/ias.10g/logRotation/listOC4JLogs.pl /main/1 2009/10/12 04:39:07 djoly Exp $
#
# listOC4JLogs.pl
# 
# Copyright (c) 2006, 2009, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      listOC4JLogs.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    vaudinar    10/26/06 - bug-5606317
#    vaudinar    06/26/06 - Creation
# 
use strict;
use File::Find;
use File::stat;
use File::Basename;
use ias::asecm;
use ias::simpleXPath;
use Cwd 'chdir';
use Cwd 'abs_path';

my $platform = getPlatform();
my $oracleHome = $ARGV[0];
my $instanceName =$ARGV[1];
setOracleHome($oracleHome);
my $serverConfigFile;
my $jmsConfigFile;
my $rmiConfigFile;
my $defaultWebSiteXml;
my $applicationXml;
my $seqNo =0;
my $relPath;
my $realPath;
my @realPathList;

if ($platform eq 'windows') {
	$_= $oracleHome;
	$oracleHome =~ s[\\][\/]g;
}

my $basePath="$oracleHome/j2ee/$instanceName/config";
$serverConfigFile = "$oracleHome/j2ee/$instanceName/config/server.xml";
$jmsConfigFile = "$oracleHome/j2ee/$instanceName/config/jms.xml";
$rmiConfigFile = "$oracleHome/j2ee/$instanceName/config/rmi.xml";
$defaultWebSiteXml = "$oracleHome/j2ee/$instanceName/config/default-web-site.xml";
$applicationXml = "$oracleHome/j2ee/$instanceName/config/application.xml";

my @results = simpleXPathQuery($serverConfigFile,'application-server/log/file');
parseLogName(\@results);

$basePath="$oracleHome/j2ee/$instanceName/config";
@results = simpleXPathQuery($jmsConfigFile,'jms-server/log/file');
parseLogName(\@results);

$basePath="$oracleHome/j2ee/$instanceName/config";
@results = simpleXPathQuery($jmsConfigFile,'jms/jms-server/log/file');
parseLogName(\@results);

$basePath="$oracleHome/j2ee/$instanceName/config";
@results = simpleXPathQuery($rmiConfigFile,'rmi-server/log/file');
parseLogName(\@results);

$basePath="$oracleHome/j2ee/$instanceName/config";
@results = simpleXPathQuery($defaultWebSiteXml,'web-site/access-log');
parseLogName(\@results);

$basePath="$oracleHome/j2ee/$instanceName/config";
@results = simpleXPathQuery($applicationXml,'orion-application/log/file');
parseLogName(\@results);

@results = simpleXPathQuery($serverConfigFile,'application-server/application');

my $appLog = 'true';
for my $result (@results)
{
	my $appName =  $$result{'name'};
	my $appConfigFile ="$oracleHome/j2ee/$instanceName/application-deployments/$appName/orion-application.xml";
	$basePath="$oracleHome/j2ee/$instanceName/application-deployments/$appName";
	my @queryResults = simpleXPathQuery($appConfigFile,'orion-application/log/file');
	parseLogName(\@queryResults, $appConfigFile, $appLog);
}

sub parseLogName {

  my $oc4jLog;
  my @results = @{$_[0]};
  my $appConfigFile = $_[1];
  my $appLog = $_[2];
  my $fileName;
  @realPathList =();

  for my $result (@results)  {
         $oc4jLog =  $$result{'path'};
  }

  if(! defined $oc4jLog) {
  	 return;	
  }
  if ($appLog eq "true") {

  	findRealPath($oc4jLog);
  	for my $realPath (@realPathList) {
  	  $seqNo++;
  	  my $logPropName = "LogFile" . "." . $seqNo;
  	  printResult($logPropName, 'string', $realPath,  'string');
  	}	
  
  }
  else {
  	
  	findRealPath($oc4jLog);
	for my $realPath (@realPathList) {
	  $seqNo++;
  	  my $logPropName = "LogFile" . $seqNo;
  	  printResult($logPropName, 'string',$realPath,    'string' );
        }	
  }
}



sub findRealPath{
	my $offset;
	my $relPath = $_[0];
	my $fileName;
	chdir "$basePath"; 
        $fileName = basename($relPath); 
  	$relPath = dirname($relPath); 
        $basePath = abs_path($relPath);

	 find(sub { 
	 
	 	 if ($_ =~ /^$fileName$/) {
	 	 	
	 	 	push @realPathList, $File::Find::name;
                }},  $basePath);
  
}




