#!/usr/local/bin/perl
# 
# $Header: emas/sysman/admin/scripts/ias.10g/oc4j/getConnectionPools.pl /main/1 2009/10/12 04:39:07 djoly Exp $
#
# getConnectionPools.pl
# 
# Copyright (c) 2005, 2009, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      getConnectionPools.pl - Get OC4J connection pools.
#
#    DESCRIPTION
#      Implements the OC4J ConnectionPools metric.
#
#    MODIFIED   (MM/DD/YY)
#    jsmoler     08/07/06 - Backport jsmoler_bug-5295826 from
#                           st_emasgc_10.2.0.1.0
#    jsmoler     06/27/06 - use new output functions 
#    jsmoler     11/29/05 - Creation
# 

use strict;
use ias::simpleXPath;
use ias::asecm;

my $oracleHome = $ARGV[0];
setOracleHome($oracleHome);
my $instanceName = $ARGV[1];

# Metric: ConnectionPools
setMetricFormat(
    { 'type' => 'string', 'key' => 1 }, # name
    { 'type' => 'string', 'key' => 1 }, # application
    { 'type' => 'string' },             # class
    { 'type' => 'string' },             # URL
    { 'type' => 'number' },             # max connections
    { 'type' => 'number' },             # min connections
    { 'type' => 'number' },             # wait timeout
    { 'type' => 'number' },             # inactivity timeout
);

my @dataSourceFiles = listOC4JDataSourceFiles($instanceName);
for my $appInfo (@dataSourceFiles)
{
    my @connectionPools = simpleXPathQueryForNodes(
        $$appInfo{'file'},
        'data-sources/connection-pool'
    );
    for my $connectionPool (@connectionPools)
    {
        my $factoryAttrs;
        for my $childNode (@{$$connectionPool{'children'}})
        {
            if ($$childNode{'tagName'} eq 'connection-factory')
            {
                $factoryAttrs = $$childNode{'attributes'};
                last;
            }
        }
        
        my $poolAttrs = $$connectionPool{'attributes'};
        
        printMetricResult(
            $$poolAttrs{'name'},
            $$appInfo{'application'},
            $$factoryAttrs{'factory-class'},
            $$factoryAttrs{'url'},
            $$poolAttrs{'max-connections'},
            $$poolAttrs{'min-connections'},
            $$poolAttrs{'used-connection-wait-timeout'},
            $$poolAttrs{'inactivity-timeout'},
        );
    }
}
