#!/usr/local/bin/perl
# 
# $Header: emas/sysman/admin/scripts/ias.10g/oif/getOIFDSConfigDetail.pl /main/3 2010/03/08 21:13:59 proxy Exp $
#
# getOIFDSConfigDetail.pl
# 
# Copyright (c) 2009, 2010, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      getOIFDSConfigDetail.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    proxy       10/13/09 - fix bug 9003955
#    proxy       07/22/09 - Creation


use strict;
use ias::simpleXPath;
use ias::asecm;
my $domainHome = $ARGV[0];

my $xmlFile; 

if(-e "$domainHome/servers/wls_oif1/stage/OIF/11.1.1.1.0/OIF/configuration/config.xml"){
	$xmlFile = "$domainHome/servers/wls_oif1/stage/OIF/11.1.1.1.0/OIF/configuration/config.xml";
}
elsif(-e "$domainHome/config/fmwconfig/servers/wls_oif1/applications/OIF_11.1.1.2.0/configuration/config.xml"){
	$xmlFile = "$domainHome/config/fmwconfig/servers/wls_oif1/applications/OIF_11.1.1.2.0/configuration/config.xml";
}
elsif(-e "$domainHome/config/fmwconfig/servers/wls_oif1/applications/OIF_11.1.1.3.0/configuration/config.xml"){
        $xmlFile = "$domainHome/config/fmwconfig/servers/wls_oif1/applications/OIF_11.1.1.3.0/configuration/config.xml";
}

my @oif;

my $fedLdapSvrUrl;
my $fedBindDN;
my $fedUserRcrdCtx;
my $fedLdapConClass;
my $fedLdapUnique;
my $fedMaxConn;
my $fedConnWait;
my $fedRdbmsJndi;
my $usrLdapSvrUrl;
my $usrBindDN;
my $usrLdapIdAttr;
my $usrLdapDescAttr;
my $usrObjClass;
my $usrBaseDN;
my $usrMaxConn;
my $usrConnWait;
my $usrRdbmsJndi;
my $usrLoginTable;
my $usrRdbmsIdAttr;
my $usrRdbmsDescAttr;

@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="datastore"]//Property[@name="fedldapserverurls"]');
$fedLdapSvrUrl = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="datastore"]//Property[@name="fedldapusername"]');
$fedBindDN = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="datastore"]//Property[@name="fedldapuserfedrecordcontext"]');
$fedUserRcrdCtx = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="datastore"]//Property[@name="fedldapcontainerclass"]');
$fedLdapConClass = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="datastore"]//Property[@name="fedldapuniquefedid"]');
$fedLdapUnique = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="datastore"]//Property[@name="fedldapmaxconnections"]');
$fedMaxConn = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="datastore"]//Property[@name="fedldapconnectionwaittimeout"]');
$fedConnWait = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="datastore"]//Property[@name="fedrdbmsjndiname"]');
$fedRdbmsJndi = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="datastore"]//Property[@name="userldapserverurls"]');
$usrLdapSvrUrl = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="datastore"]//Property[@name="userldapusername"]');
$usrBindDN = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="datastore"]//Property[@name="userldapuseridattr"]');
$usrLdapIdAttr = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="datastore"]//Property[@name="userldapuserdescriptionattr"]');
$usrLdapDescAttr = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="datastore"]//Property[@name="userldappersonobjclass"]');
$usrObjClass = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="datastore"]//Property[@name="userldapbasedn"]');
$usrBaseDN = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="datastore"]//Property[@name="userldapmaxconnections"]');
$usrMaxConn = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="datastore"]//Property[@name="userldapconnectionwaittimeout"]');
$usrConnWait = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="datastore"]//Property[@name="userrdbmsjndiname"]');
$usrRdbmsJndi = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="datastore"]//Property[@name="userrdbmstablename"]');
$usrLoginTable = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="datastore"]//Property[@name="userrdbmsuseridattr"]');
$usrRdbmsIdAttr = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="datastore"]//Property[@name="userrdbmsuserdescriptionattr"]');
$usrRdbmsDescAttr = $oif[0];

ias::asecm::printResult(
	$fedLdapSvrUrl, 'string',
	$fedBindDN, 'string',
	$fedUserRcrdCtx, 'string',
	$fedLdapConClass, 'string',
	$fedLdapUnique, 'string',
	$fedMaxConn, 'number',
	$fedConnWait, 'number',
	$fedRdbmsJndi, 'string',
	$usrLdapSvrUrl, 'string',
	$usrBindDN, 'string',
	$usrLdapIdAttr, 'string',
	$usrLdapDescAttr, 'string',
	$usrObjClass, 'string',
	$usrBaseDN, 'string',
	$usrMaxConn, 'number',
	$usrConnWait, 'number',
	$usrRdbmsJndi, 'string',
	$usrLoginTable, 'string',
	$usrRdbmsIdAttr, 'string',
	$usrRdbmsDescAttr, 'string',
);
