#!/usr/local/bin/perl
# 
# $Header: emas/sysman/admin/scripts/ias.10g/oif/getOIFIdPWSFed11PropertyDetail.pl /main/3 2010/03/08 21:13:59 proxy Exp $
#
# getOIFIdPWSFed11PropertyDetail.pl
# 
# Copyright (c) 2009, 2010, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      getOIFIdPWSFed11PropertyDetail.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    proxy       10/13/09 - fix bug 9003955
#    proxy       07/22/09 - Creation


use strict;
use ias::simpleXPath;
use ias::asecm;
my $domainHome = $ARGV[0];

my $xmlFile; 

if(-e "$domainHome/servers/wls_oif1/stage/OIF/11.1.1.1.0/OIF/configuration/config.xml"){
	$xmlFile = "$domainHome/servers/wls_oif1/stage/OIF/11.1.1.1.0/OIF/configuration/config.xml";
}
elsif(-e "$domainHome/config/fmwconfig/servers/wls_oif1/applications/OIF_11.1.1.2.0/configuration/config.xml"){
	$xmlFile = "$domainHome/config/fmwconfig/servers/wls_oif1/applications/OIF_11.1.1.2.0/configuration/config.xml";
}
elsif(-e "$domainHome/config/fmwconfig/servers/wls_oif1/applications/OIF_11.1.1.3.0/configuration/config.xml"){
        $xmlFile = "$domainHome/config/fmwconfig/servers/wls_oif1/applications/OIF_11.1.1.3.0/configuration/config.xml";
}

my @oif;

my $enableWSFed;
my $ssoTokenType;
my $wsFedAssertGen;

@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpwsfed11"]//Property[@name="wsfed11enabled"]');
my $enableWSFed = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpwsfed11"]//Property[@name="wsfedsamlassertionversion"]');
my $ssoTokenType = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="idpwsfed11"]//Property[@name="wsfedadfsmodeenabled"]');
my $wsFedAssertGen = $oif[0];

ias::asecm::printResult(
	$enableWSFed, 'string',
	$ssoTokenType, 'string',
	$wsFedAssertGen, 'string',
);
