#!/usr/local/bin/perl
# 
# $Header: emas/sysman/admin/scripts/ias.10g/oif/getOIFSPSAML20AssertPropDetail.pl /main/3 2010/03/08 21:13:59 proxy Exp $
#
# getOIFSPSAML20AssertPropDetail.pl
# 
# Copyright (c) 2009, 2010, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      getOIFSPSAML20AssertPropDetail.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    proxy       10/13/09 - fix bug 9003955
#    proxy       07/23/09 - Creation


use strict;
use ias::simpleXPath;
use ias::asecm;
my $domainHome = $ARGV[0];

my $xmlFile; 

if(-e "$domainHome/servers/wls_oif1/stage/OIF/11.1.1.1.0/OIF/configuration/config.xml"){
	$xmlFile = "$domainHome/servers/wls_oif1/stage/OIF/11.1.1.1.0/OIF/configuration/config.xml";
}
elsif(-e "$domainHome/config/fmwconfig/servers/wls_oif1/applications/OIF_11.1.1.2.0/configuration/config.xml"){
	$xmlFile = "$domainHome/config/fmwconfig/servers/wls_oif1/applications/OIF_11.1.1.2.0/configuration/config.xml";
}
elsif(-e "$domainHome/config/fmwconfig/servers/wls_oif1/applications/OIF_11.1.1.3.0/configuration/config.xml"){
        $xmlFile = "$domainHome/config/fmwconfig/servers/wls_oif1/applications/OIF_11.1.1.3.0/configuration/config.xml";
}

my @oif;
my $temp;

my $ssoAttrBaseAuthn;
my $autoAccLinkEnabled;
my $ssoUsrMapAttr;
my $ssoAttrMapQuery;
my $ssoUsrMapNameId;
my $enabledIdFormats;
my $nameFormatX500;
my $nameFormatEmail;
my $nameFormatWindows;
my $nameFormatKerberos;
my $nameFormatUnspecified;
my $nameFormatCustom;
my $customNameIdFormat;
my $attrBasedAuthnFailure;
my $ignoreUnknownCond;
my $requireSignAssert;

@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="spsaml20"]//Property[@name="ssoattributebasedauthn"]');
$ssoAttrBaseAuthn = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="spsaml20"]//Property[@name="autoaccountlinkingenabled"]');
$autoAccLinkEnabled = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="spsaml20"]//Property[@name="ssousermappingattr"]');
$ssoUsrMapAttr = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="spsaml20"]//Property[@name="ssoattributemappingquery"]');
$ssoAttrMapQuery = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="spsaml20"]//Property[@name="ssousermappingnameid"]');
$ssoUsrMapNameId = $oif[0];

@oif=ias::simpleXPath::simpleXPathQueryForText($xmlFile, 'FederationConfig//Config[@name="spsaml20"]//PropertiesList[@name="nameidformats"]/Property');
foreach $temp (@oif) {
	if($enabledIdFormats){
		$enabledIdFormats = $enabledIdFormats . " , " . $temp;
	}
	else{
		$enabledIdFormats = $temp;
	}
}

@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="spsaml20"]//Property[@name="nameformatx500"]');
$nameFormatX500 = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="spsaml20"]//Property[@name="nameformatemail"]');
$nameFormatEmail = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="spsaml20"]//Property[@name="nameformatwindows"]');
$nameFormatWindows = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="spsaml20"]//Property[@name="nameformatkerberos"]');
$nameFormatKerberos = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="spsaml20"]//Property[@name="nameformatunspecified"]');
$nameFormatUnspecified = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="spsaml20"]//Property[@name="nameformatcustom"]');
$nameFormatCustom = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="spsaml20"]//Property[@name="customnameidformat"]');
$customNameIdFormat = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="spsaml20"]//Property[@name="ssoattributebasedauthnfailure"]');
$attrBasedAuthnFailure = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="spsaml20"]//Property[@name="ignoreunknownconditions"]');
my $num = @oif;
if($num == 0){
	@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="spglobal"]//Property[@name="ignoreunknownconditions"]');
}
$ignoreUnknownCond = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="spsaml20"]//Property[@name="requiresignedassertion"]');
$requireSignAssert = $oif[0];

ias::asecm::printResult(
	$ssoAttrBaseAuthn, 'string',
	$autoAccLinkEnabled, 'string',
	$ssoUsrMapAttr, 'string',
	$ssoAttrMapQuery, 'string',
	$ssoUsrMapNameId, 'string',
	$enabledIdFormats, 'string',
	$nameFormatX500, 'string',
	$nameFormatEmail, 'string',
	$nameFormatWindows, 'string',
	$nameFormatKerberos, 'string',
	$nameFormatUnspecified, 'string',
	$nameFormatCustom, 'string',
	$customNameIdFormat, 'string',
	$attrBasedAuthnFailure, 'string',
	$ignoreUnknownCond, 'string',
	$requireSignAssert, 'string',
);
