#!/usr/local/bin/perl
# 
# $Header: emas/sysman/admin/scripts/ias.10g/oif/getOIFSPSAML20ProtoPropDetail.pl /main/3 2010/03/08 21:13:59 proxy Exp $
#
# getOIFSPSAML20ProtoPropDetail.pl
# 
# Copyright (c) 2009, 2010, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      getOIFSPSAML20ProtoPropDetail.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    proxy       10/13/09 - fix bug 9003955
#    proxy       07/23/09 - Creation


use strict;
use ias::simpleXPath;
use ias::asecm;
my $domainHome = $ARGV[0];

my $xmlFile; 

if(-e "$domainHome/servers/wls_oif1/stage/OIF/11.1.1.1.0/OIF/configuration/config.xml"){
	$xmlFile = "$domainHome/servers/wls_oif1/stage/OIF/11.1.1.1.0/OIF/configuration/config.xml";
}
elsif(-e "$domainHome/config/fmwconfig/servers/wls_oif1/applications/OIF_11.1.1.2.0/configuration/config.xml"){
	$xmlFile = "$domainHome/config/fmwconfig/servers/wls_oif1/applications/OIF_11.1.1.2.0/configuration/config.xml";
}
elsif(-e "$domainHome/config/fmwconfig/servers/wls_oif1/applications/OIF_11.1.1.3.0/configuration/config.xml"){
        $xmlFile = "$domainHome/config/fmwconfig/servers/wls_oif1/applications/OIF_11.1.1.3.0/configuration/config.xml";
}

my @oif;
my $temp;

my $saml20Enabled;
my $rniEnabled;
my $fedTermEnabled;
my $sendEncryptNameId;
my $sendEncryptAttr;
my $allowFedCreation;
my $forceConsentUrl;
my $forceConsent;
my $enableProtocolBindings;
my $defaultBinding;
my $defaultSSOReqBinding;
my $defaultSSORespBinding;
my $defaultAuthReqNameIdFormat;
my $requestAuthMech;
my $requestAuthComp;
my $sendSignAuthnReq;
my $sendSignReqPost;
my $sendSignReqQuery;
my $sendSignReqSoap;
my $sendSignRespPost;
my $sendSignRespQuery;
my $sendSignRespSoap;
my $requireSignReqPost;
my $requireSignReqQuery;
my $requireSignReqSoap;
my $requireSignRespPost;
my $requireSignRespQuery;
my $requireSignRespSoap;
my $requireSignRespAssertPost;
my $requireSignRespAssertSoap;

@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="spsaml20"]//Property[@name="saml20enabled"]');
$saml20Enabled = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="spsaml20"]//Property[@name="rnienabled"]');
$rniEnabled = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="spsaml20"]//Property[@name="fedtermenabled"]');
$fedTermEnabled = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="spsaml20"]//Property[@name="sendencryptednameid"]');
$sendEncryptNameId = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="spsaml20"]//Property[@name="sendencryptedattribute"]');
$sendEncryptAttr = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="spsaml20"]//Property[@name="allowfederationcreation"]');
$allowFedCreation = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="spsaml20"]//Property[@name="forceconsenturl"]');
$forceConsentUrl = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="spsaml20"]//Property[@name="forceconsent"]');
$forceConsent = $oif[0];

@oif=ias::simpleXPath::simpleXPathQueryForText($xmlFile, 'FederationConfig//Config[@name="spsaml20"]//PropertiesList[@name="assertionbindings"]/Property');
foreach $temp (@oif) {
	if($enableProtocolBindings){
		$enableProtocolBindings = $enableProtocolBindings . " , " . $temp;
	}
	else{
		$enableProtocolBindings = $temp;
	}
}
@oif=ias::simpleXPath::simpleXPathQueryForText($xmlFile, 'FederationConfig//Config[@name="spsaml20"]//PropertiesList[@name="slobindings"]/Property');
foreach $temp (@oif) {
	if($enableProtocolBindings){
		$enableProtocolBindings = $enableProtocolBindings . " , " . $temp;
	}
	else{
		$enableProtocolBindings = $temp;
	}
}
@oif=ias::simpleXPath::simpleXPathQueryForText($xmlFile, 'FederationConfig//Config[@name="spsaml20"]//PropertiesList[@name="mnibindings"]/Property');
foreach $temp (@oif) {
	if($enableProtocolBindings){
		$enableProtocolBindings = $enableProtocolBindings . " , " . $temp;
	}
	else{
		$enableProtocolBindings = $temp;
	}
}

@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="spsaml20"]//Property[@name="defaultbinding"]');
$defaultBinding = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="spsaml20"]//Property[@name="defaultssorequestbinding"]');
$defaultSSOReqBinding = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="spsaml20"]//Property[@name="defaultssoresponsebinding"]');
$defaultSSORespBinding = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="spsaml20"]//Property[@name="defaultauthnrequestnameidformat"]');
$defaultAuthReqNameIdFormat = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="spsaml20"]//Property[@name="requestauthnmechanism"]');
$requestAuthMech = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="spsaml20"]//Property[@name="requestauthncomparison"]');
$requestAuthComp = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="spsaml20"]//Property[@name="sendsignedauthnrequest"]');
$sendSignAuthnReq = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="spsaml20"]//Property[@name="sendsignedrequestpost"]');
$sendSignReqPost = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="spsaml20"]//Property[@name="sendsignedrequestquery"]');
$sendSignReqQuery = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="spsaml20"]//Property[@name="sendsignedrequestsoap"]');
$sendSignReqSoap = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="spsaml20"]//Property[@name="sendsignedresponsepost"]');
$sendSignRespPost = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="spsaml20"]//Property[@name="sendsignedresponsequery"]');
$sendSignRespQuery = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="spsaml20"]//Property[@name="sendsignedresponsesoap"]');
$sendSignRespSoap = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="spsaml20"]//Property[@name="requiresignedrequestpost"]');
$requireSignReqPost = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="spsaml20"]//Property[@name="requiresignedrequestquery"]');
$requireSignReqQuery = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="spsaml20"]//Property[@name="requiresignedrequestsoap"]');
$requireSignReqSoap = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="spsaml20"]//Property[@name="requiresignedresponsepost"]');
$requireSignRespPost = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="spsaml20"]//Property[@name="requiresignedresponsequery"]');
$requireSignRespQuery = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="spsaml20"]//Property[@name="requiresignedresponsesoap"]');
$requireSignRespSoap = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="spsaml20"]//Property[@name="requiresignedresponseassertionpost"]');
$requireSignRespAssertPost = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="spsaml20"]//Property[@name="requiresignedresponseassertionsoap"]');
$requireSignRespAssertSoap = $oif[0];

ias::asecm::printResult(
	$saml20Enabled, 'string',
	$rniEnabled, 'string',
	$fedTermEnabled, 'string',
	$sendEncryptNameId, 'string',
	$sendEncryptAttr, 'string',
	$allowFedCreation, 'string',
	$forceConsentUrl, 'string',
	$forceConsent, 'string',
	$enableProtocolBindings, 'string',
	$defaultBinding, 'string',
	$defaultSSOReqBinding, 'string',
	$defaultSSORespBinding, 'string',
	$defaultAuthReqNameIdFormat, 'string',
	$requestAuthMech, 'string',
	$requestAuthComp, 'string',
	$sendSignAuthnReq, 'string',
	$sendSignReqPost, 'string',
	$sendSignReqQuery, 'string',
	$sendSignReqSoap, 'string',
	$sendSignRespPost, 'string',
	$sendSignRespQuery, 'string',
	$sendSignRespSoap, 'string',
	$requireSignReqPost, 'string',
	$requireSignReqQuery, 'string',
	$requireSignReqSoap, 'string',
	$requireSignRespPost, 'string',
	$requireSignRespQuery, 'string',
	$requireSignRespSoap, 'string',
	$requireSignRespAssertPost, 'string',
	$requireSignRespAssertSoap, 'string',
);
