#!/usr/local/bin/perl
# 
# $Header: emas/sysman/admin/scripts/ias.10g/oif/getSPSAML1xAssertProtoDetail.pl /main/3 2010/03/08 21:13:59 proxy Exp $
#
# getSPSAML1xAssertProtoDetail.pl
# 
# Copyright (c) 2009, 2010, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      getSPSAML1xAssertProtoDetail.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    proxy       10/13/09 - fix bug 9003955
#    proxy       07/23/09 - Creation


use strict;
use ias::simpleXPath;
use ias::asecm;
my $domainHome = $ARGV[0];

my $xmlFile; 

if(-e "$domainHome/servers/wls_oif1/stage/OIF/11.1.1.1.0/OIF/configuration/config.xml"){
	$xmlFile = "$domainHome/servers/wls_oif1/stage/OIF/11.1.1.1.0/OIF/configuration/config.xml";
}
elsif(-e "$domainHome/config/fmwconfig/servers/wls_oif1/applications/OIF_11.1.1.2.0/configuration/config.xml"){
	$xmlFile = "$domainHome/config/fmwconfig/servers/wls_oif1/applications/OIF_11.1.1.2.0/configuration/config.xml";
}
elsif(-e "$domainHome/config/fmwconfig/servers/wls_oif1/applications/OIF_11.1.1.3.0/configuration/config.xml"){
        $xmlFile = "$domainHome/config/fmwconfig/servers/wls_oif1/applications/OIF_11.1.1.3.0/configuration/config.xml";
}

my @oif;
my $temp;

my $usrMapAttr;
my $attrQuery;
my $usrMapNameid;
my $enabledIdFormats;
my $nameFormatX500;
my $nameFormatEmail;
my $nameFormatWindows;
my $nameFormatUnspecified;
my $nameFormatCustom;
my $customNameIdFormat;
my $attrBasedAuthnFailure;
my $ignoreUnknownCond;
my $requireSignAssert;
my $saml10Enabled;
my $saml11Enabled;
my $enableProtocolBindings;
my $sendSignReqSoap;
my $reqSignRespAssertPost;
my $reqSignRespAssertSoap;

@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="spsaml10"]//Property[@name="ssousermappingattr"]');
$usrMapAttr = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="spsaml10"]//Property[@name="ssoattributemappingquery"]');
$attrQuery = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="spsaml10"]//Property[@name="ssousermappingnameid"]');
$usrMapNameid = $oif[0];

@oif=ias::simpleXPath::simpleXPathQueryForText($xmlFile, 'FederationConfig//Config[@name="spsaml10"]//PropertiesList[@name="nameidformats"]/Property');
foreach $temp (@oif) {
	if($enabledIdFormats){
		$enabledIdFormats = $enabledIdFormats . " , " . $temp;
	}
	else{
		$enabledIdFormats = $temp;
	}
}

@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="spsaml10"]//Property[@name="nameformatx500"]');
$nameFormatX500 = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="spsaml10"]//Property[@name="nameformatemail"]');
$nameFormatEmail = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="spsaml10"]//Property[@name="nameformatwindows"]');
$nameFormatWindows = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="spsaml10"]//Property[@name="nameformatunspecified"]');
$nameFormatUnspecified = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="spsaml10"]//Property[@name="nameformatcustom"]');
$nameFormatCustom = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="spsaml10"]//Property[@name="customnameidformat"]');
$customNameIdFormat = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="spsaml10"]//Property[@name="ssoattributebasedauthnfailure"]');
$attrBasedAuthnFailure = $oif[0];

@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="spsaml10"]//Property[@name="ignoreunknownconditions"]');
my $num = @oif;
if($num == 0){
	@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="spglobal"]//Property[@name="ignoreunknownconditions"]');
}
$ignoreUnknownCond = $oif[0];

@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="spsaml10"]//Property[@name="requiresignedassertion"]');
$requireSignAssert = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="spsaml10"]//Property[@name="saml10enabled"]');
$saml10Enabled = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="spsaml11"]//Property[@name="saml11enabled"]');
$saml11Enabled = $oif[0];

@oif=ias::simpleXPath::simpleXPathQueryForText($xmlFile, 'FederationConfig//Config[@name="spsaml10"]//PropertiesList[@name="assertionbindings"]/Property');
foreach $temp (@oif) {
	if($enableProtocolBindings){
		$enableProtocolBindings = $enableProtocolBindings . " , " . $temp;
	}
	else{
		$enableProtocolBindings = $temp;
	}
}

@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="spsaml10"]//Property[@name="sendsignedrequestsoap"]');
$sendSignReqSoap = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="spsaml10"]//Property[@name="requiresignedresponseassertionpost"]');
$reqSignRespAssertPost = $oif[0];
@oif = ias::simpleXPath::simpleXPathQueryForText($xmlFile,'FederationConfig//Config[@name="spsaml10"]//Property[@name="requiresignedresponseassertionsoap"]');
$reqSignRespAssertSoap = $oif[0];

ias::asecm::printResult(
	$usrMapAttr, 'string',
	$attrQuery, 'string',
	$usrMapNameid, 'string',
	$enabledIdFormats, 'string',
	$nameFormatX500, 'string',
	$nameFormatEmail, 'string',
	$nameFormatWindows, 'string',
	$nameFormatUnspecified, 'string',
	$nameFormatCustom, 'string',
	$customNameIdFormat, 'string',
	$attrBasedAuthnFailure, 'string',
	$ignoreUnknownCond, 'string',
	$requireSignAssert, 'string',
	$saml10Enabled, 'string',
	$saml11Enabled, 'string',
	$enableProtocolBindings, 'string',
	$sendSignReqSoap, 'string',
	$reqSignRespAssertPost, 'string',
	$reqSignRespAssertSoap, 'string',
);
