#!/usr/local/bin/perl
# 
# $Header: emas/sysman/admin/scripts/ias.10g/ovd/getOVDListenerDetail.pl /st_emasgc_11.1/1 2010/01/20 20:44:41 proxy Exp $
#
# getOVDListenerDetail.pl
# 
# Copyright (c) 2009, 2010, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      getOVDListenerDetail.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    proxy       07/20/09 - ovd_config_collection
#    proxy       07/20/09 - Creation
# 

use strict;
use ias::simpleXPath;
use ias::asecm;
my $oracleInstance = $ARGV[0];
my $targetName = $ARGV[1];
my $slash = '/';
my $indexOf = rindex($targetName,$slash);
my $displayName = substr($targetName,$indexOf+1);

my $xmlFile;

$xmlFile = "$oracleInstance/config/OVD/$displayName/listeners.os_xml";

my @ovd;
my @ssl;
my @listeners;
my $listener;
my $temp;

my $lsnrName;
my $lsnrType;
my $lsnrVer;
my $lsnrActive;
my $lsnrHost;
my $lsnrPort;
my $threads;
my $groupUrl;
my $sslEnabled;
my $sslAuthType;
my $sslTrustStore;
my $sslKeyStore;
my $sslProtocols;
my $sslCiphers;

@listeners = ias::simpleXPath::simpleXPathQuery($xmlFile, 'listeners//admin');
for $listener (@listeners) {
	$lsnrType = "ADMIN";
	getAllValues($listener,"admin");
	printAllValues();
}

@listeners = ias::simpleXPath::simpleXPathQuery($xmlFile, 'listeners//ldap');
for $listener (@listeners) {
	$lsnrType = "LDAP";
	getAllValues($listener,"ldap");
	printAllValues();
}

@listeners = ias::simpleXPath::simpleXPathQuery($xmlFile, 'listeners//http');
for $listener (@listeners) {
	$lsnrType = "HTTP";
	getAllValues($listener,"http");
	printAllValues();

}

sub getAllValues{
	my $tempCiphers;
	my $lsnrTemp = $_[0];
	my $tagName = $_[1];
	$lsnrName = $$lsnrTemp{'id'};
	$lsnrVer = $$lsnrTemp{'version'};
	
	@ovd = ias::simpleXPath::simpleXPathQueryForText($xmlFile, 'listeners//' . $tagName . '[@id="' . $lsnrName . '"]/active');
	$lsnrActive = $ovd[0];

	@ovd = ias::simpleXPath::simpleXPathQueryForText($xmlFile, 'listeners//' . $tagName . '[@id="' . $lsnrName . '"]/host');
	$lsnrHost = $ovd[0];

	@ovd = ias::simpleXPath::simpleXPathQueryForText($xmlFile, 'listeners//' . $tagName . '[@id="' . $lsnrName . '"]/port');
	$lsnrPort = $ovd[0];

	@ovd = ias::simpleXPath::simpleXPathQueryForText($xmlFile, 'listeners//' . $tagName . '[@id="' . $lsnrName . '"]/threads');
	$threads = $ovd[0];

	@ovd = ias::simpleXPath::simpleXPathQueryForText($xmlFile, 'listeners//' . $tagName . '[@id="' . $lsnrName . '"]/groupUrl');
	$groupUrl = $ovd[0];

	@ssl = ias::simpleXPath::simpleXPathQuery($xmlFile, 'listeners//' . $tagName . '[@id="' . $lsnrName . '"]//ssl');
	for my $ssl (@ssl) {
		$sslEnabled = $$ssl{'enabled'};
		
		@ovd = ias::simpleXPath::simpleXPathQueryForText($xmlFile, 'listeners//' . $tagName . '[@id="' . $lsnrName . '"]/ssl/authType');
		$sslAuthType = $ovd[0];

		@ovd = ias::simpleXPath::simpleXPathQueryForText($xmlFile, 'listeners//' . $tagName . '[@id="' . $lsnrName . '"]/ssl/trustStore');
		$sslTrustStore = $ovd[0];

		@ovd = ias::simpleXPath::simpleXPathQueryForText($xmlFile, 'listeners//' . $tagName . '[@id="' . $lsnrName . '"]/ssl/keyStore');
		$sslKeyStore = $ovd[0];

		@ovd = ias::simpleXPath::simpleXPathQueryForText($xmlFile, 'listeners//' . $tagName . '[@id="' . $lsnrName . '"]/ssl/protocols');
		$sslProtocols = $ovd[0];

		@ovd = ias::simpleXPath::simpleXPathQueryForText($xmlFile, 'listeners//' . $tagName . '[@id="' . $lsnrName . '"]/ssl/cipherSuites/cipher');
		foreach $temp (@ovd) {
			if($tempCiphers){
				$tempCiphers = $tempCiphers . " , " . $temp;
			}
			else{
				$tempCiphers = $temp;
			}
		}
		$sslCiphers = $tempCiphers;
	}
}

sub printAllValues{
	ias::asecm::printResult(
		$lsnrName, 'string',
		$lsnrType, 'string',
		$lsnrVer, 'number',
		$lsnrActive, 'string',
		$lsnrHost, 'string',
		$lsnrPort, 'string',
		$threads, 'number',
		$groupUrl, 'string',
		$sslEnabled, 'string',
		$sslAuthType, 'string',
		$sslTrustStore, 'string',
		$sslKeyStore, 'string',
		$sslProtocols, 'string',
		$sslCiphers, 'string',
	);
}
