#!/usr/local/bin/perl
# 
# $Header: emas/sysman/admin/scripts/ias.10g/ovd/getOVDSearchDetail.pl /main/1 2010/12/21 21:26:43 proxy Exp $
#
# getOVDSearchDetail.pl
# 
# Copyright (c) 2010, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      getOVDSearchDetail.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    proxy       11/26/10 - fix_bug_9587140
#    proxy       11/26/10 - Creation
# 

use strict;
use ias::simpleXPath;
use ias::asecm;
my $oracleInstance = $ARGV[0];
my $targetName = $ARGV[1];
my $slash = '/';
my $indexOf = rindex($targetName,$slash);
my $displayName = substr($targetName,$indexOf+1);
my $xmlFile;

$xmlFile = "$oracleInstance/config/OVD/$displayName/server.os_xml";

my @ovd;
my $temp;

@ovd = ias::simpleXPath::simpleXPathQueryForText($xmlFile, 'server/searchLimit/anonymous');
my $anonymousSearch = $ovd[0];

@ovd = ias::simpleXPath::simpleXPathQueryForText($xmlFile, 'server/searchLimit/authenticated');
my $authenticatedSearch = $ovd[0];

@ovd = ias::simpleXPath::simpleXPathQueryForText($xmlFile, 'server/persistentSearch');
my $persistentSearch = $ovd[0];

ias::asecm::printResult(
	$anonymousSearch, 'number',
	$authenticatedSearch, 'number',
	$persistentSearch, 'string',
);