#!/usr/local/bin/perl
# 
# $Header: emas/sysman/admin/scripts/ias.10g/ovd/getOVDServerDetail.pl /main/3 2010/12/21 21:26:43 proxy Exp $
#
# getOVDServerDetail.pl
# 
# Copyright (c) 2009, 2010, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      getOVDServerDetail.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    proxy       11/26/10 - fix_bug_9587140
#    proxy       07/20/09 - ovd_config_collection
#    proxy       07/20/09 - Creation
# 

use strict;
use ias::simpleXPath;
use ias::asecm;
my $oracleInstance = $ARGV[0];
my $targetName = $ARGV[1];
my $slash = '/';
my $indexOf = rindex($targetName,$slash);
my $displayName = substr($targetName,$indexOf+1);
my $xmlFile;

$xmlFile = "$oracleInstance/config/OVD/$displayName/server.os_xml";

my @ovd;
my $temp;

@ovd = ias::simpleXPath::simpleXPathQueryForText($xmlFile, 'server/searchLimit/anonymous');
my $anonymousSearch = $ovd[0];

@ovd = ias::simpleXPath::simpleXPathQueryForText($xmlFile, 'server/searchLimit/authenticated');
my $authenticatedSearch = $ovd[0];

@ovd = ias::simpleXPath::simpleXPathQueryForText($xmlFile, 'server/persistentSearch');
my $persistentSearch = $ovd[0];

my $aclCheck;
if(ias::simpleXPath::simpleXPathQueryForText($xmlFile, 'server/acls[@check="true"]')){
	$aclCheck = "true";
}
elsif(ias::simpleXPath::simpleXPathQueryForText($xmlFile, 'server/acls[@check="false"]')){
	$aclCheck = "false";
}

my $quotaActive;
if(ias::simpleXPath::simpleXPathQueryForText($xmlFile, 'server/quota[@active="true"]')){
	$quotaActive = "true";
}
elsif(ias::simpleXPath::simpleXPathQueryForText($xmlFile, 'server/quota[@active="false"]')){
	$quotaActive = "false";
}

my $exemptIP;
@ovd = ias::simpleXPath::simpleXPathQueryForText($xmlFile, 'server/quota/exemptip/address');
foreach $temp (@ovd) {
	if($exemptIP){
		$exemptIP = $exemptIP . " , " . $temp;
	}
	else{
		$exemptIP = $temp;
	}
}

my $exemptSubject;
@ovd = ias::simpleXPath::simpleXPathQueryForText($xmlFile, 'server/quota/exemptsubject/subject');
foreach $temp (@ovd) {
	if($exemptSubject){
		$exemptSubject = $exemptSubject . " , " . $temp;
	}
	else{
		$exemptSubject = $temp;
	}
}

my $maxConnTimeout;
@ovd = ias::simpleXPath::simpleXPathQueryForText($xmlFile, 'server/quota/max/inactiveConnectionTimeout');
$maxConnTimeout = $ovd[0];

my $maxOpsPerConn;
@ovd = ias::simpleXPath::simpleXPathQueryForText($xmlFile, 'server/quota/max/opspercon');
$maxOpsPerConn = $ovd[0];

my $maxConns;
@ovd = ias::simpleXPath::simpleXPathQueryForText($xmlFile, 'server/quota/max/connections');
$maxConns = $ovd[0];

my $maxConnPerSub;
@ovd = ias::simpleXPath::simpleXPathQueryForText($xmlFile, 'server/quota/max/consPerSubject');
$maxConnPerSub = $ovd[0];

my $maxConnPerIP;
@ovd = ias::simpleXPath::simpleXPathQueryForText($xmlFile, 'server/quota/max/consPerIp');
$maxConnPerIP = $ovd[0];

my $ratePeriod;
@ovd = ias::simpleXPath::simpleXPathQueryForText($xmlFile, 'server/quota/ratePeriod');
$ratePeriod = $ovd[0];

my $schemaCheck;
if(ias::simpleXPath::simpleXPathQueryForText($xmlFile, 'server/schema[@check="true"]')){
	$schemaCheck = "true";
}
elsif(ias::simpleXPath::simpleXPathQueryForText($xmlFile, 'server/schema[@check="false"]')){
	$schemaCheck = "false";
}

ias::asecm::printResult(
	$anonymousSearch, 'number',
	$authenticatedSearch, 'number',
	$persistentSearch, 'string',
	$quotaActive, 'string',
	$exemptIP, 'string',
	$exemptSubject, 'string',
	$maxConnTimeout, 'number',
	$maxOpsPerConn, 'number',
	$maxConns, 'number',
	$maxConnPerSub, 'number',
	$maxConnPerIP, 'number',
	$ratePeriod, 'number',
	$aclCheck, 'string',
	$schemaCheck, 'string',
);