#!/usr/local/bin/perl
# 
# $Header: emas/sysman/admin/scripts/ias.10g/weblogic_j2eeserver/JDBCDataSource.pl /main/2 2011/10/24 20:59:07 gisivaku Exp $
#
# JDBCDataSources.pl
# 
# Copyright (c) 2008, 2011, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      JDBCDataSources.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    gisivaku    09/14/11 - XbranchMerge
#                           gisivaku_new_ocm_collections_for_10.3.7 from main
#    gisivaku    08/21/11 - Fetching the values of the new
#                           jdbc-connection-pool-params columns
#                           'StatementCacheType' and 'PinnedToThread' added to
#                           the 'JDBCDataSource' metric to fix bugs: 12422277,
#                           12422248.
#    sasachde    04/10/11 - Fix for bug#9716634
#    jsmoler     12/23/08 - fix 7665185
#    jsmoler     11/19/08 - don't use schema
#    jsmoler     11/07/08 - Creation
# 

use strict;
use File::Spec;
use ias::simpleXPath;
use ias::weblogic_j2eeserver::ServerConfigUtil;

my ( $domainHome, $serverName, $adminServer ) = @ARGV;

my $configFileName = "$domainHome/config/config.xml";
if ( ! -e $configFileName )
{
    die "Config file not found";
}
my $configFile = ias::simpleXPath::parseFile($configFileName);

my @descriptorNames = getServerComponentNames($configFile, 'jdbc-system-resource', $serverName);
for my $descriptorName (@descriptorNames)
{
    my $descriptorFileName = (ias::simpleXPath::queryForText($configFile,
        'domain/jdbc-system-resource[name="' . $descriptorName . '"]/descriptor-file-name'))[0];
    $descriptorFileName = File::Spec->rel2abs($descriptorFileName, "$domainHome/config");
    if (-e $descriptorFileName)
    {
        my $descriptorFile = ias::simpleXPath::parseFile($descriptorFileName);
        
        # Check whether the data source is a multi-datasource by looking for
        # the data-source-list tag
        my $dataSourceList = (ias::simpleXPath::queryForText($descriptorFile,
            'jdbc-data-source/jdbc-data-source-params/data-source-list'))[0];
        if (defined($dataSourceList))
        {
            # This is a multi-datasource
            next;
        }

        my $globalTransactionsProtocol = (ias::simpleXPath::queryForText($descriptorFile,
            'jdbc-data-source/jdbc-data-source-params/global-transactions-protocol'))[0];
        my $twoPhaseCommit = (defined($globalTransactionsProtocol) && $globalTransactionsProtocol eq 'TwoPhaseCommit') ? 'true' : 'false';

        print 'em_result='
              . (ias::simpleXPath::queryForText($descriptorFile,
                    'jdbc-data-source/name'))[0]
        . '|' . (ias::simpleXPath::queryForText($descriptorFile,
                    'jdbc-data-source/jdbc-data-source-params/jndi-name'))[0]
        . '|' . (ias::simpleXPath::queryForText($descriptorFile,
                    'jdbc-data-source/jdbc-data-source-params/row-prefetch'))[0]
        . '|' . (ias::simpleXPath::queryForText($descriptorFile,
                    'jdbc-data-source/jdbc-data-source-params/row-prefetch-size'))[0]
        . '|' . $twoPhaseCommit
        . '|' . (ias::simpleXPath::queryForText($descriptorFile,
                    'jdbc-data-source/jdbc-driver-params/url'))[0]
        . '|' . (ias::simpleXPath::queryForText($descriptorFile,
                    'jdbc-data-source/jdbc-driver-params/driver-name'))[0]
        . '|' . (ias::simpleXPath::queryForText($descriptorFile,
                    'jdbc-data-source/jdbc-connection-pool-params/capacity-increment'))[0]
        . '|' . (ias::simpleXPath::queryForText($descriptorFile,
                    'jdbc-data-source/jdbc-connection-pool-params/initial-capacity'))[0]
        . '|' . (ias::simpleXPath::queryForText($descriptorFile,
                    'jdbc-data-source/jdbc-connection-pool-params/max-capacity'))[0]
        . '|' . (ias::simpleXPath::queryForText($descriptorFile,
                    'jdbc-data-source/jdbc-connection-pool-params/connection-reserve-timeout-seconds'))[0]
        . '|' . (ias::simpleXPath::queryForText($descriptorFile,
                    'jdbc-data-source/jdbc-connection-pool-params/inactive-connection-timeout-seconds'))[0]
        . '|' . (ias::simpleXPath::queryForText($descriptorFile,
                    'jdbc-data-source/jdbc-connection-pool-params/statement-cache-size'))[0]
        . '|'
        . '|'
        . '|'
        . '|'
        . '|'
        . '|'
        . '|'
        . '|' . (ias::simpleXPath::queryForText($descriptorFile,
                    'jdbc-data-source/jdbc-connection-pool-params/statement-cache-type'))[0]
        . '|' . (ias::simpleXPath::queryForText($descriptorFile,
                    'jdbc-data-source/jdbc-connection-pool-params/pinned-to-thread'))[0]
        . "\n";
    }
}
