#!/usr/local/bin/perl
# 
# $Header: emas/sysman/admin/scripts/ias.10g/weblogic_j2eeserver/JDBCMultiDataSource.pl /main/1 2011/04/12 03:25:33 sasachde Exp $
#
# JDBCMultiDataSources.pl
# 
# Copyright (c) 2008, 2011, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      JDBCMultiDataSources.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    jsmoler     12/23/08 - fix 7665185
#    jsmoler     11/19/08 - don't use schema
#    jsmoler     11/07/08 - Creation
# 

use strict;
use File::Spec;
use ias::simpleXPath;
use ias::weblogic_j2eeserver::ServerConfigUtil;

my ( $domainHome, $serverName, $adminServer ) = @ARGV;

my $configFileName = "$domainHome/config/config.xml";
if ( ! -e $configFileName )
{
    die "Config file not found";
}
my $configFile = ias::simpleXPath::parseFile($configFileName);

my @descriptorNames = getServerComponentNames($configFile, 'jdbc-system-resource', $serverName);
for my $descriptorName (@descriptorNames)
{
    my $descriptorFileName = (ias::simpleXPath::queryForText($configFile,
        'domain/jdbc-system-resource[name="' . $descriptorName . '"]/descriptor-file-name'))[0];
    $descriptorFileName = File::Spec->rel2abs($descriptorFileName, "$domainHome/config");
    if (-e $descriptorFileName)
    {
        my $descriptorFile = ias::simpleXPath::parseFile($descriptorFileName);
        
        # Check whether the data source is a multi-datasource by looking for
        # the data-source-list tag
        my $dataSourceList = (ias::simpleXPath::queryForText($descriptorFile,
            'jdbc-data-source/jdbc-data-source-params/data-source-list'))[0];
        if (!defined($dataSourceList))
        {
            # This is not a multi-datasource
            next;
        }

        print 'em_result='
              . (ias::simpleXPath::queryForText($descriptorFile,
                    'jdbc-data-source/name'))[0]
        . '|' . (ias::simpleXPath::queryForText($descriptorFile,
                    'jdbc-data-source/jdbc-data-source-params/jndi-name'))[0]
        . '|' . (ias::simpleXPath::queryForText($descriptorFile,
                    'jdbc-data-source/jdbc-data-source-params/algorithm-type'))[0]
        . '|' . $dataSourceList
        . "\n";
    }
}
