#!/usr/local/bin/perl
# 
# $Header: emas/sysman/admin/scripts/ias.10g/weblogic_j2eeserver/JMSConnectionFactory.pl /main/1 2011/04/12 03:25:33 sasachde Exp $
#
# JMSConnectionFactories.pl
# 
# Copyright (c) 2008, 2011, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      JMSConnectionFactories.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    jsmoler     12/23/08 - fix 7665185
#    jsmoler     11/19/08 - don't use schema
#    jsmoler     11/07/08 - Creation
# 

use strict;
use File::Spec;
use ias::simpleXPath;
use ias::weblogic_j2eeserver::ServerConfigUtil;

my ( $domainHome, $serverName, $adminServer ) = @ARGV;

my $configFileName = "$domainHome/config/config.xml";
if ( ! -e $configFileName )
{
    die "Config file not found";
}
my $configFile = ias::simpleXPath::parseFile($configFileName);

my @jmsDescriptorNames = getServerComponentNames($configFile, 'jms-system-resource', $serverName);
for my $descriptorName (@jmsDescriptorNames)
{
    my $moduleName = $descriptorName;
    my $descriptorFileName = (ias::simpleXPath::queryForText($configFile,
        'domain/jms-system-resource[name="' . $descriptorName . '"]/descriptor-file-name'))[0];
    $descriptorFileName = File::Spec->rel2abs($descriptorFileName, "$domainHome/config");
    if (-e $descriptorFileName)
    {
        my $descriptorFile = ias::simpleXPath::parseFile($descriptorFileName);
        my @connectionFactories = ias::simpleXPath::queryForNodes($descriptorFile,
            'weblogic-jms/connection-factory');
        for my $connectionFactory (@connectionFactories)
        {
            print 'em_result='
                  . $$connectionFactory{'attributes'}{'name'}
            . '|' . $moduleName
            . '|' . (ias::simpleXPath::queryForText($connectionFactory,
                        'connection-factory/jndi-name'))[0]
            . '|' . (ias::simpleXPath::queryForText($connectionFactory,
                        'connection-factory/transaction-params/transaction-timeout'))[0]
            . '|' . (ias::simpleXPath::queryForText($connectionFactory,
                        'connection-factory/client-params/acknowledge-policy'))[0]
            . '|' . (ias::simpleXPath::queryForText($connectionFactory,
                        'connection-factory/client-params/messages-maximum'))[0]
            . '|' . (ias::simpleXPath::queryForText($connectionFactory,
                        'connection-factory/default-delivery-params/send-timeout'))[0]
            . "\n";
        }
    }
}
