#!/usr/local/bin/perl
# 
# $Header: emas/sysman/admin/scripts/ias.10g/weblogic_j2eeserver/JMSQueue.pl /main/2 2011/10/24 20:59:07 gisivaku Exp $
#
# JMSQueues.pl
# 
# Copyright (c) 2008, 2011, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      JMSQueues.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    gisivaku    09/14/11 - XbranchMerge
#                           gisivaku_new_ocm_collections_for_10.3.7 from main
#    gisivaku    09/01/11 - Changes to report queue's config metrics only if
#                           the queue is deployed on the current target through
#                           subdeployment. Correcting retrieval of
#                           {bytes|messages}-maximum to obtain them from the
#                           quota and returning the target for the new metric
#                           column defined.
#    sasachde    04/10/11 - Fix for bug#9716634
#    jsmoler     12/23/08 - fix 7665185
#    jsmoler     11/19/08 - don't use schema
#    jsmoler     11/07/08 - Creation
# 

use strict;
use File::Spec;
use ias::simpleXPath;
use ias::weblogic_j2eeserver::ServerConfigUtil;
use ias::weblogic_j2eeserver::JMSConfigUtil;

my ( $domainHome, $serverName, $adminServer ) = @ARGV;

my $configFileName = "$domainHome/config/config.xml";
if ( ! -e $configFileName )
{
    die "Config file not found";
}
my $configFile = ias::simpleXPath::parseFile($configFileName);

my @jmsDescriptorNames = getServerComponentNames($configFile, 'jms-system-resource', $serverName);
for my $descriptorName (@jmsDescriptorNames)
{
    my $moduleName = $descriptorName;
    my $descriptorFileName = (ias::simpleXPath::queryForText($configFile,
        'domain/jms-system-resource[name="' . $descriptorName . '"]/descriptor-file-name'))[0];
    $descriptorFileName = File::Spec->rel2abs($descriptorFileName, "$domainHome/config");
    if (-e $descriptorFileName)
    {
        my %subDeployments = getSubDepolyments($configFile, $serverName, $descriptorName);
        my $descriptorFile = ias::simpleXPath::parseFile($descriptorFileName);
        my @queues = ias::simpleXPath::queryForNodes($descriptorFile, 'weblogic-jms/queue');
        for my $queue (@queues)
        {
            my $target = $subDeployments{(ias::simpleXPath::queryForText($queue, 'queue/sub-deployment-name'))[0]};
            if (defined($target))
            {
                my $queueName = $$queue{'attributes'}{'name'};
                my %quotaProperties = getQuotas($descriptorFile, 'queue', $queueName);
                print 'em_result='
                      . $queueName
                . '|' . $moduleName
                . '|' . (ias::simpleXPath::queryForText($queue, 'queue/jndi-name'))[0]
                . '|' . (ias::simpleXPath::queryForText($queue, 'queue/maximum-message-size'))[0]
                . '|' . $quotaProperties{'bytes-maximum'}
                . '|' . $quotaProperties{'messages-maximum'}
                . '|'
                . '|'
                . '|'
                . '|' . $target
                . "\n";
            }
        }
    }
}
