#!/usr/local/bin/perl
# 
# $Header: emas/sysman/admin/scripts/ias.10g/weblogic_j2eeserver/JMSServer.pl /main/1 2011/10/24 20:59:07 gisivaku Exp $
#
# JMSServer.pl
# 
# Copyright (c) 2011, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      JMSServer.pl - OCM script for collecting JMSServer config metric
#
#    DESCRIPTION
#      Perl script to be called by the OSLineToken fetchlet to collect the data 
#      for the JMSServer config metric for the OCM Collector.
#
#    NOTES
#      Arguments:
#       1) The path to the Domain home of the Weblogic Domain, containing the 
#          config directory.
#       2) Name of the WLS Server target for wich the JMSServer metric is being 
#          colleted.
#
#    MODIFIED   (MM/DD/YY)
#    gisivaku    09/02/11 - Perl script to be called by the OSLineToken
#                           fetchlet to collect the data for the new JMSServer
#                           config metric for the OCM Collector.
#    gisivaku    09/02/11 - Creation
# 

use strict;
use File::Spec;
use ias::simpleXPath;
use ias::weblogic_j2eeserver::ServerConfigUtil;

my ( $domainHome, $serverName ) = @ARGV;

my $configFileName = "$domainHome/config/config.xml";
if ( ! -e $configFileName )
{
    die "Config file not found";
}
my $configFile = ias::simpleXPath::parseFile($configFileName);

my $servers = [ $serverName, getServerCluster($configFile, $serverName)];
my @jmsServers = ias::simpleXPath::queryForNodes($configFile, 'domain/jms-server');
for my $jmsServer (@jmsServers)
{
    my $targetStr = (ias::simpleXPath::queryForText($jmsServer, 'jms-server/target'))[0];
    
    if(isTargetted($targetStr, $servers))
    {
        print 'em_result='
                      . (ias::simpleXPath::queryForText($jmsServer, 'jms-server/name'))[0]
                . '|' . (ias::simpleXPath::queryForText($jmsServer, 'jms-server/bytes-maximum'))[0]
                . '|' . (ias::simpleXPath::queryForText($jmsServer, 'jms-server/messages-maximum'))[0]
                . '|' . (ias::simpleXPath::queryForText($jmsServer, 'jms-server/message-buffer-size'))[0]
                . '|' . (ias::simpleXPath::queryForText($jmsServer, 'jms-server/maximum-message-size'))[0]
                . "\n";
    }
}
