#!/usr/local/bin/perl
#
# getBpelDomainDetail.pl
#
# Copyright (c) 2004, 2007, Oracle. All rights reserved.  
#
#    NAME
#      getBpelDomainDetail.pl - BPEL PM ECM integration
#
#    DESCRIPTION
#      Command line utility called by the Agent to retrieve a list of configuration
#      files for Apache. Outputs the full path, size, and modification time of each
#      file (see statFiles in asecm.pm).
#
#      Implements the ConfigFileList metric defined in oracle_integrationbpm.xml.
#
#      Command-line arguments: <oracle home>
#
#    NOTES
#
#    MODIFIED   (MM/DD/YY)
#    kotkumar    07/27/07 - Updating for BPEL 10.1.2.
#    rsaraswa    05/20/07 - Creation


use strict;
use ias::simpleXPath;
use ias::asecm;
use ias::bpel::confFileParser;
my $oracleHome = $ARGV[0];
my $domainHome;

if(-e  "$oracleHome/bpel/domains")
{
	$domainHome = "$oracleHome/bpel/domains";
}else {	
	$domainHome = "$oracleHome/integration/orabpel/domains";

}
opendir(DIR,"$domainHome");
my @domains = readdir(DIR);
closedir(DIR);
for my $domain (@domains) 
{
if ($domain eq ".") { next;}
if ($domain eq "..") {next;}

my $xmlFile = "$domainHome/$domain/config/domain.xml";

my $txjndi  = (ias::simpleXPath::simpleXPathQueryForText($xmlFile, 'bpel-domain-descriptor//property[@id="txDatasourceJndi"]/value'))[0];
my $adthreshhold  = (ias::simpleXPath::simpleXPathQueryForText($xmlFile, 'bpel-domain-descriptor//property[@id="auditDetailThreshold"]/value'))[0];
my $dlpolicy  = (ias::simpleXPath::simpleXPathQueryForText($xmlFile, 'bpel-domain-descriptor//property[@id="deliveryPersistPolicy"]/value'))[0];
my $dsjndi  = (ias::simpleXPath::simpleXPathQueryForText($xmlFile, 'bpel-domain-descriptor//property[@id="datasourceJndi"]/value'))[0];
my $dspInvokeAllocFactor  = (ias::simpleXPath::simpleXPathQueryForText($xmlFile, 'bpel-domain-descriptor//property[@id="dspInvokeAllocFactor"]/value'))[0];
my $dspMaxRequestDepth  = (ias::simpleXPath::simpleXPathQueryForText($xmlFile, 'bpel-domain-descriptor//property[@id="dspMaxRequestDepth"]/value'))[0];
my $dspMaxThreads  = (ias::simpleXPath::simpleXPathQueryForText($xmlFile, 'bpel-domain-descriptor//property[@id="dspMaxThreads"]/value'))[0];
my $dspMinThreads  = (ias::simpleXPath::simpleXPathQueryForText($xmlFile, 'bpel-domain-descriptor//property[@id="dspMinThreads"]/value'))[0];

#for my $propertyAttrs (@allPropertyAttrs)
#{
#   my $id = $$propertyAttrs{'id'};
#   my $name = (ias::simpleXPath::simpleXPathQueryForText($xmlFile, 'bpel-server-descriptor//property[@id="' . $id . '"]/name'))[0];
#   my $value = (ias::simpleXPath::simpleXPathQueryForText($xmlFile, 'bpel-server-descriptor//property[@id="' . $id . '"]/value'))[0];
ias::asecm::printResult(
     $domain,      'string',
     $txjndi,    'string',
     $adthreshhold ,   'string',
     $dlpolicy,    'string',
     $dsjndi,    'string',
     $dspMaxRequestDepth,    'number',
     $dspInvokeAllocFactor,    'string',
     $dspMaxThreads,    'number',
     $dspMinThreads,    'number',
     );

} #end for domains
