#!/usr/local/bin/perl

use strict;

my $oracleHome = $ARGV[0];
my $Version = $ARGV[1];
my $VersionCategory =  $ARGV[2];
my $principal = $ARGV[3];
my $contextFactory =  $ARGV[4];
my $providerURL =  $ARGV[5];
my $seperator;
my $pathSeperator;

if(!&IsWindows())
{
	$pathSeperator = "/";
	$seperator = ":";
}
else
{
	$pathSeperator = "\\";
	$seperator = ";";
}

my $BPEL_HOME = $oracleHome.$pathSeperator."bpel";
my $EJB_OB_ENGINE_PATH;
my $AGENT_HOME;
my $metric;
my $APPSERVER_HOME;
my $COMMAND;
if($VersionCategory eq "1013plus_WS")
{
		
	$ENV{'WAS_HOME'} = "$ARGV[6]";
	$EJB_OB_ENGINE_PATH = $ARGV[7];
	$AGENT_HOME = $ARGV[8];
	
	$ENV{'JAVA_HOME'}=$ENV{'WAS_HOME'}.$pathSeperator."java";
	$ENV{'ITP_LOC'}=$ENV{'WAS_HOME'}.$pathSeperator."deploytool".$pathSeperator."itp";
	$ENV{'WAS_CLASSPATH'} = $ENV{'WAS_HOME'}.$pathSeperator."properties".$seperator.$ENV{'WAS_HOME'}.$pathSeperator."lib".$pathSeperator."startup.jar".$seperator.$ENV{'WAS_HOME'}.$pathSeperator."lib".$pathSeperator."bootstrap.jar".$seperator.$ENV{'JAVA_HOME'}.$pathSeperator."lib".$pathSeperator."tools.jar".$seperator.$ENV{'WAS_HOME'}.$pathSeperator."lib".$pathSeperator."j2ee.jar".$seperator.$ENV{'WAS_HOME'}.$pathSeperator."lib".$pathSeperator."lmproxy.jar".$seperator.$ENV{'WAS_HOME'}.$pathSeperator."lib".$pathSeperator."urlprotocols.jar";
	$ENV{'PATH'}=$ENV{'JAVA_HOME'}.$pathSeperator."ibm_bin".$seperator.$ENV{'JAVA_HOME'}.$pathSeperator."bin".$pathSeperator..$seperator.$ENV{'JAVA_HOME'}.$pathSeperator."jre".$pathSeperator."bin".$seperator.$ENV{'PATH'};

	
	$ENV{'WAS_EXT_DIRS'}=$ENV{'JAVA_HOME'}.$pathSeperator."lib".$seperator.$ENV{'WAS_HOME'}.$pathSeperator."classes".$seperator.$ENV{'WAS_HOME'}.$pathSeperator."lib".$seperator.$ENV{'WAS_HOME'}.$pathSeperator."installedChannels".$seperator.$ENV{'WAS_HOME'}.$pathSeperator."lib".$pathSeperator."ext".$seperator.$ENV{'WAS_HOME'}.$pathSeperator."web".$pathSeperator."help".$seperator.$ENV{'ITP_LOC'}.$pathSeperator."plugins".$pathSeperator."com.ibm.etools.ejbdeploy".$pathSeperator."runtime";

	$ENV{'CLASSPATH'} = $ENV{'WAS_CLASSPATH'}.$seperator.$EJB_OB_ENGINE_PATH.$seperator.$BPEL_HOME.$pathSeperator."lib".$pathSeperator."orabpel.jar".$seperator.$BPEL_HOME.$pathSeperator."lib".$pathSeperator."orabpel-thirdparty.jar".$seperator.$BPEL_HOME.$pathSeperator."lib".$pathSeperator."orabpel-common.jar".$seperator.$AGENT_HOME.$pathSeperator."oui".$pathSeperator."jlib".$pathSeperator."xmlparserv2.jar".$seperator.$AGENT_HOME.$pathSeperator."sysman".$pathSeperator."jlib".$pathSeperator."emagentRT.jar".$seperator.$AGENT_HOME.$pathSeperator."sysman".$pathSeperator."jlib".$pathSeperator."emagentSDK.jar";
	$COMMAND = $ENV{'JAVA_HOME'}.$pathSeperator."jre".$pathSeperator."bin".$pathSeperator."java  -Djava.ext.dirs=".$ENV{'JAVA_HOME'}.$pathSeperator."jre".$pathSeperator."lib".$pathSeperator."ext".$seperator.$ENV{'WAS_EXT_DIRS'}.$seperator.$ENV{'WAS_HOME'}.$pathSeperator."plugins".$seperator.$ENV{'WAS_HOME'}.$pathSeperator."lib".$pathSeperator."WMQ".$pathSeperator."java".$pathSeperator."lib oracle.sysman.emd.fetchlets.BPELPMFetchlet $oracleHome $Version $VersionCategory $principal $contextFactory $providerURL";
	system($COMMAND);
}

else
{
	$APPSERVER_HOME = $ARGV[6];
	$AGENT_HOME = $ARGV[7];
	my $cpStatus = setWeblogicClasspath();
	#Checking the number of arguments to obtain the metric name

	if($cpStatus == 1)
	{
		if ( @ARGV >= 9)
        	{
                	 $metric = $ARGV[8];
		}
	
	#If the obtained metric name is BPELStatusMetric then pass the metric name value to the fetchlet. Otherwise don't pass the argument.
		if($metric eq 'BPELStatusMetric')
		{
			$COMMAND = $ENV{'ORACLE_HOME'}.$pathSeperator."jdk".$pathSeperator."bin".$pathSeperator."java  oracle.sysman.emd.fetchlets.BPELPMFetchlet $oracleHome $Version $VersionCategory $principal $contextFactory $providerURL $metric";
			 system($COMMAND);
        	}
        	else
	        {
			$COMMAND = $ENV{'ORACLE_HOME'}.$pathSeperator."jdk".$pathSeperator."bin".$pathSeperator."java oracle.sysman.emd.fetchlets.BPELPMFetchlet $oracleHome $Version $VersionCategory $principal $contextFactory $providerURL";
			system($COMMAND);
	        }
	}
}

#setWeblogicClasspath - Used to set the required classpath inorder to execute the fetchlet.

sub setWeblogicClasspath()
{
#	$WEBLOGIC_JARS - used to set in the classpath.
#        my $WEBLOGIC_JARS = getWeblogicJars();
	my $WEBLOGIC_JARS = $APPSERVER_HOME.$pathSeperator."server".$pathSeperator."lib".$pathSeperator."wlclient.jar";
	my $cpStatus=0;
	if(-e  $BPEL_HOME.$pathSeperator."lib".$pathSeperator."orabpel.jar")
	{
        	$ENV{'CLASSPATH'} = $BPEL_HOME.$pathSeperator."lib".$pathSeperator."orabpel.jar".$seperator.$BPEL_HOME.$pathSeperator."lib".$pathSeperator."orabpel-common.jar".$seperator.$AGENT_HOME.$pathSeperator."sysman".$pathSeperator."jlib".$pathSeperator."emagentRT.jar".$seperator.$AGENT_HOME.$pathSeperator."sysman".$pathSeperator."jlib".$pathSeperator."emagentSDK.jar".$seperator.$AGENT_HOME.$pathSeperator."jlib".$pathSeperator."emConfigInstall.jar".$seperator.$AGENT_HOME.$pathSeperator."jlib".$pathSeperator."http_client.jar".$seperator.$AGENT_HOME.$pathSeperator."sysman".$pathSeperator."jlib".$pathSeperator."log4j-core.jar".$seperator.$WEBLOGIC_JARS;
		$cpStatus = 1;
	}
	else
	{
		print "\nem_warning=Unable to collect metric information. Oracle Home path ".$oracleHome." is invalid. Correct the specified Oracle home path or specify another valid location\n";
		$cpStatus = 0;
	}
	return $cpStatus;
}
sub IsWindows 
{
    my $osname = $^O;
    if (   $osname eq "Windows_NT"
        || $osname eq "MSWin32"
        || $osname eq "MSWin64" )
    {
        return 1;
    }
    else 
    {
        return 0;
    }
}


