#!/usr/local/bin/perl
#
# getDataSourceDetails.pl
#
# Copyright (c) 2004, 2007, Oracle. All rights reserved.  
#
#    NAME
#      getDataSourceDetails.pl - BPEL PM ECM integration
#
#    DESCRIPTION
#      Command line utility called by the Agent to retrieve a list of configuration
#      files for Apache. Outputs the full path, size, and modification time of each
#      file (see statFiles in asecm.pm).
#
#      Implements the ConfigFileList metric defined in oracle_integrationbpm.xml.
#
#      Command-line arguments: <oracle home>
#
#    NOTES
#
#    MODIFIED   (MM/DD/YY)
#    rsaraswa    09/19/07 - Changes for thirparty
#    kotkumar    07/27/07 - Updating for BPEL 10.1.2
#    rsaraswa    05/20/07 - Creation


use strict;
use ias::simpleXPath;
use ias::asecm;
my $oracleHome = $ARGV[0];
my $oc4jHome = $ARGV[1];
my $xmlFile;

if(-e  "$oracleHome/bpel/system/config/collaxa-config.xml")
{
	$xmlFile = "$oracleHome/bpel/system/config/collaxa-config.xml";
}else {
	$xmlFile = "$oracleHome/integration/orabpel/system/config/collaxa-config.xml";
}

my $datasourceJndi = (ias::simpleXPath::simpleXPathQueryForText($xmlFile, 'bpel-server-descriptor//property[@id="datasourceJndi"]/value'))[0];

my @ds = split('\/',$datasourceJndi);
my $dsname = $ds[1];
my $connectionpoolname;
my $url;
my $host;
my $port;
my $servicename;
my $dsfile;
if(-e "$oracleHome/j2ee/$oc4jHome/config/data-sources.xml")
{
   $dsfile = "$oracleHome/j2ee/$oc4jHome/config/data-sources.xml";


	my @matches = ias::simpleXPath::simpleXPathQuery($dsfile, 'data-sources//managed-data-source[@name="'.$dsname.'"]');
	for my $match (@matches)
	{
	   $connectionpoolname = $$match{'connection-pool-name'};
	   my @factorys = ias::simpleXPath::simpleXPathQuery($dsfile, 'data-sources//connection-pool[@name="'.$connectionpoolname.'"]/connection-factory');
	   for my $factory (@factorys) {
		 $url = $$factory{'url'};

	   }
	 if($url =~ /.+HOST=(.+)\)\(PORT=(\d+)\)\)\)\(CONNECT_DATA=\(SERVICE_NAME=(.+)\)\)\)/) {
 		$host =  $1;
		$port = $2;
		$servicename = $3;
		}
#   $jndiName = $$match{'jndi-name'};
#   $txlevel = $$match{'tx-level'};
} 

}elsif(-e "$oracleHome/j2ee/OC4J_BPEL/config/data-sources.xml"){
	#In case of 10.1.2 targets, the connection pool details are not available
	#Hard coding the OC4J Home for BPEL 10.1.2 target type
   $dsfile = "$oracleHome/j2ee/OC4J_BPEL/config/data-sources.xml";
	my @matches = ias::simpleXPath::simpleXPathQuery($dsfile, 'data-sources//data-source[@location="'.$datasourceJndi.'"]');
	for my $match (@matches)
	{
 		$url = $$match{'url'};
	}
	 if($url =~ /.+HOST=(.+)\)\(PORT=(\d+)\)\)\)\(CONNECT_DATA=\(SERVICE_NAME=(.+)\)\)\)/) {
        $host =  $1;
        $port = $2;
        $servicename = $3;
        }


}

ias::asecm::printResult(
     $datasourceJndi,      'string',
     $connectionpoolname,    'string',
     $host,   'string',
     $port,   'string',
     $servicename,   'string',
);




