#!/usr/local/bin/perl
# 
# $Header: getConsoleInfo.pl 23-dec-2005.12:18:25 jsmoler Exp $
#
# IAS_getConsoleInfo.pl
# 
# Copyright (c) 2004, 2005, Oracle. All rights reserved.  
#
#    NAME
#      IAS_getConsoleInfo.pl - IAS ECM integration: get console configuration information
#
#    DESCRIPTION
#      Command-line utility called by the Agent to retrieve console configuration
#      information for IAS. Includes the agent and console URLs.
#
#      Implements the ConsoleInfo metric defined in oracle_ias.xml.
#
#      Command-line arguments: <oracle home> <host name>
#
#    NOTES
#
#    MODIFIED   (MM/DD/YY)
#    jsmoler     12/23/05 - handle case of no emd.properties file for 10.1.3 
#    jsmoler     12/10/04 - no error if xml file not found 
#    jsmoler     12/03/04 - change url to path 
#    jsmoler     12/02/04 - fail if xml file not found 
#    jsmoler     10/04/04 - jsmoler_ecm01
#    jsmoler     09/13/04 - Creation
# 

use strict;
use ias::asecm;
use ias::propertiesFileParser;
use ias::simpleXPath;

my $oracleHome = $ARGV[0];
setOracleHome($oracleHome);
my $hostName = $ARGV[1];

my $emdProtocol;
my $emdHost;
my $emdPort;
my $emdPath;
my $emdPropsFile = "$oracleHome/sysman/config/emd.properties";
if (-e $emdPropsFile)
{
    my %hash = parsePropertiesFile($emdPropsFile);
    my $emdURL = $hash{'EMD_URL'};
    if ($emdURL =~ /^([^:]*):\/\/([^:\/]*):([0-9]*)\/(.*)/)
    {
        $emdProtocol = $1;
        $emdHost = $2;
        $emdPort = $3;
        $emdPath = $4;
    }
}

my $webSite;
my $consoleProtocol;
my $consoleHost;
my $consolePort;
my $xmlFile = "$oracleHome/sysman/j2ee/config/emd-web-site.xml";
if (-e $xmlFile)
{
    my $webSite = (simpleXPathQuery($xmlFile, 'web-site'))[0];
    if (defined($$webSite{'protocol'}))
    {
        $consoleProtocol = $$webSite{'protocol'};
    }
    else
    {
        $consoleProtocol = 'http';
    }
    $consoleHost = $hostName;
    $consolePort = $$webSite{'port'};
}

printResult(
    $emdProtocol,       'string',
    $emdHost,           'string',
    $emdPort,           'number',
    $emdPath,           'string',
    $consoleProtocol,   'string',
    $consoleHost,       'string',
    $consolePort,       'number',
);
