#!/usr/local/bin/perl
# 
# $Header: getDeployedApps.pl 23-jul-2006.15:26:27 jsmoler Exp $
#
# getDeployedApps.pl
# 
# Copyright (c) 2004, 2006, Oracle. All rights reserved.  
#
#    NAME
#      getDeployedApps.pl - IAS ECM integration: get deployed applications
#
#    DESCRIPTION
#      Command-line utility called by the Agent to retrieve a list of deployed
#      applications for an IAS instance.
#
#      Implements the DeployedApps metric defined in oracle_ias.xml.
#
#      Command-line arguments: <oracle home> <version category>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    jsmoler     06/26/06 - use new output functions 
#    jsmoler     12/27/05 - support 10.1.3 system app 
#    jsmoler     10/29/04 - jsmoler_ecm_041021a
#    jsmoler     10/20/04 - Creation
# 

use strict;
use ias::asecm;

my $oracleHome = $ARGV[0];
setOracleHome($oracleHome);
my $versionCategory = $ARGV[1];

# Metric: DeployedApps
setMetricFormat(
    { 'type' => 'string', 'key' => 1 }, # OC4J instance name
    { 'type' => 'string', 'key' => 1 }, # application name
);

my @instances = listOC4JInstances();
for my $instanceName (@instances)
{
    my @apps = listOC4JDeployedApps($instanceName, $versionCategory);
    for my $appName (@apps)
    {
        printMetricResult($instanceName, $appName);
    }
}
