#!/usr/local/bin/perl
# 
# $Header: getGeneral.pl 03-jan-2006.07:55:19 jsmoler Exp $
#
# IAS_getGeneral.pl
# 
# Copyright (c) 2004, 2006, Oracle. All rights reserved.  
#
#    NAME
#      IAS_getGeneral.pl - IAS ECM integration: get general configuration information
#
#    DESCRIPTION
#      Command-line utility called by the Agent to retrieve general configuration
#      information for IAS.
#
#      Implements the General metric defined in oracle_ias.xml.
#
#      Command-line arguments: <oracle home> <install type> <version>
#
#    NOTES
#
#    MODIFIED   (MM/DD/YY)
#    jsmoler     12/29/05 - special case 10.1.3 core install type 
#    jsmoler     01/31/05 - check InfrastructureUse
#    jsmoler     10/04/04 - jsmoler_ecm01
#    jsmoler     09/13/04 - Creation
# 

use strict;
use ias::asecm;
use ias::propertiesFileParser;

my $oracleHome = $ARGV[0];
setOracleHome($oracleHome);
my $installType = $ARGV[1];
my $version = $ARGV[2];

my %hash = parsePropertiesFile("$oracleHome/config/ias.properties");

my $dbName;
if ($hash{'InfrastructureUse'} ne 'false')
{
    $dbName = $hash{'InfrastructureDBCommonName'};
}

printResult(
    $installType,         'string',
    $dbName,              'string',
    $version,             'string',
);
