#!/usr/local/bin/perl
# 
# $Header: IAS_getOPMNInfo.pl 04-oct-2004.14:32:26 jsmoler Exp $
#
# IAS_getOPMNInfo.pl
# 
# Copyright (c) 2004, Oracle. All rights reserved.  
#
#    NAME
#      IAS_getOPMNInfo.pl - IAS ECM integration: get OPMN-related configuration information
#
#    DESCRIPTION
#      Command-line utility called by the Agent to retrieve OPMN-related configuration
#      information for IAS.
#
#      Implements the OPMNInfo metric defined in oracle_ias.xml.
#
#      Command-line arguments: <oracle home>
#
#    NOTES
#
#    MODIFIED   (MM/DD/YY)
#    jsmoler     10/04/04 - jsmoler_ecm01
#    jsmoler     09/13/04 - Creation
# 

use strict;
use ias::asecm;
use ias::simpleXPath;

my $oracleHome = $ARGV[0];
setOracleHome($oracleHome);
my $xmlFile = "$oracleHome/opmn/conf/opmn.xml";

my $port = (simpleXPathQuery($xmlFile, 'opmn/notification-server/port'))[0];
my $ssl = (simpleXPathQuery($xmlFile, 'opmn/notification-server/ssl'))[0];
my $nsLog = (simpleXPathQuery($xmlFile, 'opmn/notification-server/log-file'))[0];
my $pmLog = (simpleXPathQuery($xmlFile, 'opmn/process-manager/log-file'))[0];

printResult(
    $$port{'request'},          'number',
    $$port{'remote'},           'number',
    $$port{'local'},            'number',
    $$ssl{'enabled'} eq 'true', 'number',
    $$nsLog{'level'},           'number',
    $$pmLog{'level'},           'number',
);
