#!/usr/local/bin/perl
# 
# $Header: IAS_listConfigFiles.pl 03-aug-2005.08:25:58 jsmoler Exp $
#
# IAS_listConfigFiles.pl
# 
# Copyright (c) 2004, 2005, Oracle. All rights reserved.  
#
#    NAME
#      IAS_listConfigFiles.pl - IAS ECM integration: list configuration files
#
#    DESCRIPTION
#      Command line utility called by the Agent to retrieve a list of configuration
#      files for IAS. Outputs the full path, size, and modification time of each
#      file (see statFiles in asecm.pm).
#
#      Implements the ConfigFileList metric defined in oracle_ias.xml.
#
#      Command-line arguments: <oracle home> <for upload flag> <target name>
#
#    NOTES
#
#    MODIFIED   (MM/DD/YY)
#    jsmoler     08/03/05 - collapse statFiles and restatFiles 
#    jsmoler     10/04/04 - jsmoler_ecm01
#    jsmoler     09/13/04 - Creation
# 

use strict;
use ias::asecm;

my $oracleHome = $ARGV[0];
setOracleHome($oracleHome);
my $forUploadStr = $ARGV[1];
my $forUpload = $forUploadStr eq 'true';
my $targetName = $ARGV[2];

statFiles(
    $forUpload,
    $targetName,
    
    'config/ias.properties',
    'opmn/conf/opmn.xml',
    'opmn/conf/ons.conf',
    'dcm/config/dcm.conf',
    'dcm/config/susmgmtProperties.xml',
    'dcm/config/dcmCache.xml',
    'network/admin/sqlnet.ora',
    'network/admin/tnsnames.ora',
    'sysman/config/emagentlogging.properties',
    'sysman/config/emd.properties',
    'sysman/config/emiasconsole.properties',
    'sysman/config/emiasconsolelogging.properties',
    'sysman/config/iasadmin.properties',
    'sysman/config/modPlsqlMigrateDMS.properties',
    'sysman/j2ee/config/emd-web-site.xml',
    'sysman/j2ee/config/jazn-data.xml',
    'sysman/j2ee/config/server.xml',
    'sysman/javacache/admin/javacache.xml',
    'diagnostics/config/logloader.xml',
    'diagnostics/config/logloaderd.properties',
);
