#!/usr/local/bin/perl
# 
# $Header: emas/sysman/admin/scripts/ias.11g/logRotation/listOHSlogs.pl /main/6 2009/10/12 04:38:31 djoly Exp $
#
# listOHSlogs.pl
# 
# Copyright (c) 2006, 2009, Oracle and/or its affiliates. All rights reserved. 
#
#    NAME
#      listOHSlogs.pl - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    jsmoler     04/23/08 - Backport jsmoler_bug-6319688 from main
#    jsmoler     08/09/06 - call parseApacheConf (bug 5224028)
#    vaudinar    06/26/06 - Creation
# 
use strict;
use Cwd 'chdir';
use Cwd 'abs_path';
use File::Basename;
use File::Spec;
use ias::Apache_confFileParser;
use ias::asecm;
my $oracleHome = $ARGV[0];
setOracleHome($oracleHome);
my $hash = parseApacheConf();
my $platform = getPlatform();
my $errorLog;
my $accessLog;
my $serverRoot;
my $seqNo=0;

$serverRoot = peek($$hash{'ServerRoot'});
$accessLog = $$hash{'CustomLog'};

my $i;
my $nitems;
if(defined($accessLog)) {
   $nitems = scalar(@$accessLog);
   for ($i=0; $i<$nitems;$i++)  {
               parseApacheLogDir(@$accessLog[$i]);
   }

}
$errorLog = $$hash{'ErrorLog'};

if(defined($errorLog)) {
   $nitems = scalar(@$errorLog);

   for ($i=0; $i<$nitems;$i++)  {

    parseApacheLogDir(@$errorLog[$i]);

   }
}

sub parseApacheLogDir
{
   my $apacheLog = $_[0];          
   if ( $apacheLog =~ /^\"\|.*$/ || $apacheLog =~ /^\|.*$/) {
     return;
   }
   my $endIndex = index($apacheLog, " ");
   if($endIndex != -1) {                 
   	$apacheLog = substr($apacheLog, 0,  $endIndex);
   }   
   if ( $apacheLog =~ /^\".*$/ && $apacheLog =~ /.*\"$/) {
       $apacheLog = substr($apacheLog,1);            
       my $len = length($apacheLog);
       $apacheLog = substr($apacheLog,0,$len-1);       
   }
   if( defined $apacheLog) {       
   	$apacheLog = findRealPath($apacheLog);          
   }

   if(!defined $apacheLog) {
       return;       
   }       
   $seqNo++;
   my $logPropName ="LogFile" . $seqNo;
   printResult(
     $logPropName, 'string',
     $apacheLog,    'string',
   );

}

sub findRealPath{
   my $offset;
   my $path = $_[0];
   my $fileName;
   my $basePath;
   my $dirname;

   chdir "$serverRoot";
   $fileName = basename($path);
   $dirname = dirname($path);
   $basePath = abs_path($dirname);
       $basePath=File::Spec->catfile($basePath, $fileName);
   if(! -e $basePath) {
       return;
   }
   return $basePath;
   
}   
