#!/usr/local/bin/perl
# 
# $Header: getAppInfo.pl 23-jul-2006.15:26:27 jsmoler Exp $
#
# getAppInfo.pl
# 
# Copyright (c) 2004, 2006, Oracle. All rights reserved.  
#
#    NAME
#      getAppInfo.pl - OC4J ECM integration: get application configuration
#                           information
#
#    DESCRIPTION
#      Command-line utility called by the Agent to retrieve configuration
#      information for applications in an OC4J instance.
#
#      Implements the ApplicationInfo metric defined in oc4j.xml.
#
#      Command-line arguments: <oracle home> <instance name> <version category>
#
#    NOTES
#
#    MODIFIED   (MM/DD/YY)
#    jsmoler     06/27/06 - use new output functions 
#    jsmoler     12/23/05 - support system app for 10.1.3 
#    echolank    12/08/05 - pull out common code 
#    jsmoler     10/20/04 - use 'default' as default parent
#    jsmoler     10/04/04 - jsmoler_ecm01
#    jsmoler     08/26/04 - Creation
# 

use strict;
use ias::asecm;

my $oracleHome = $ARGV[0];
setOracleHome($oracleHome);
my $instanceName = $ARGV[1];
my $versionCategory = $ARGV[2];

# Metric: ApplicationInfo
setMetricFormat(
    { 'type' => 'string', 'key' => 1 }, # application name
    { 'type' => 'string' },             # parent name
);

my @results = listOC4JAppInfo($instanceName, $versionCategory);
for my $resultRef (@results)
{
    my $name = $$resultRef{'name'};
    my $parent = $$resultRef{'parent'};
    if (!defined($parent) && $name ne 'default')
    {
        $parent = 'default';
    }
    printMetricResult($name, $parent);
}
