#!/usr/local/bin/perl
# 
# $Header: getConnectionPools.pl 23-jul-2006.15:26:27 jsmoler Exp $
#
# getConnectionPools.pl
# 
# Copyright (c) 2005, 2006, Oracle. All rights reserved.  
#
#    NAME
#      getConnectionPools.pl - Get OC4J connection pools.
#
#    DESCRIPTION
#      Implements the OC4J ConnectionPools metric.
#
#    MODIFIED   (MM/DD/YY)
#    jsmoler     06/27/06 - use new output functions 
#    jsmoler     11/29/05 - Creation
# 

use strict;
use ias::simpleXPath;
use ias::asecm;

my $oracleHome = $ARGV[0];
setOracleHome($oracleHome);
my $instanceName = $ARGV[1];

# Metric: ConnectionPools
setMetricFormat(
    { 'type' => 'string', 'key' => 1 }, # name
    { 'type' => 'string', 'key' => 1 }, # application
    { 'type' => 'string' },             # class
    { 'type' => 'string' },             # URL
    { 'type' => 'number' },             # max connections
    { 'type' => 'number' },             # min connections
    { 'type' => 'number' },             # wait timeout
    { 'type' => 'number' },             # inactivity timeout
);

my @dataSourceFiles = listOC4JDataSourceFiles($instanceName);
for my $appInfo (@dataSourceFiles)
{
    my @connectionPools = simpleXPathQueryForNodes(
        $$appInfo{'file'},
        'data-sources/connection-pool'
    );
    for my $connectionPool (@connectionPools)
    {
        my $factoryAttrs;
        for my $childNode (@{$$connectionPool{'children'}})
        {
            if ($$childNode{'tagName'} eq 'connection-factory')
            {
                $factoryAttrs = $$childNode{'attributes'};
                last;
            }
        }
        
        my $poolAttrs = $$connectionPool{'attributes'};
        
        printMetricResult(
            $$poolAttrs{'name'},
            $$appInfo{'application'},
            $$factoryAttrs{'factory-class'},
            $$factoryAttrs{'url'},
            $$poolAttrs{'max-connections'},
            $$poolAttrs{'min-connections'},
            $$poolAttrs{'used-connection-wait-timeout'},
            $$poolAttrs{'inactivity-timeout'},
        );
    }
}
