#!/usr/local/bin/perl
# 
# $Header: OC4J_getGlobalWebSettings.pl 29-oct-2004.17:57:16 jsmoler Exp $
#
# OC4J_getWebModuleSettings.pl
# 
# Copyright (c) 2004, Oracle. All rights reserved.  
#
#    NAME
#      OC4J_getWebModuleSettings.pl - OC4J ECM integration: get web module settings
#
#    DESCRIPTION
#      Command-line utility called by the Agent to retrieve global web module settings
#      for a given OC4J instance.
#
#      Implements the GlobalWebSettings metric defined in oc4j.xml.
#
#      Command-line arguments: <oracle home> <instance name>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    jsmoler     10/29/04 - jsmoler_ecm_041021a
#    jsmoler     10/04/04 - jsmoler_ecm01
#    jsmoler     09/10/04 - Creation
# 

use strict;
use ias::asecm;
use ias::simpleXPath;

my $oracleHome = $ARGV[0];
setOracleHome($oracleHome);
my $instanceName = $ARGV[1];

my %info = parseWebAppInfo("$oracleHome/j2ee/$instanceName/config/global-web-application.xml");

printResult(
    $info{'jspMode'},           'string',
    $info{'sessionTimeout'},    'number',
);
