#!/usr/local/bin/perl
# 
# $Header: getPortRanges.pl 23-jul-2006.15:26:27 jsmoler Exp $
#
# getPortRanges.pl
# 
# Copyright (c) 2004, 2006, Oracle. All rights reserved.  
#
#    NAME
#      getPortRanges.pl - OC4J ECM integration: get port ranges
#
#    DESCRIPTION
#      Command-line utility called by the Agent to retrieve port ranges
#      configured for an OC4J instance.
#
#      Implements the PortRanges metric defined in oc4j.xml.
#
#      Command-line arguments: <oracle home> <instance name>
#
#    NOTES
#
#    MODIFIED   (MM/DD/YY)
#    jsmoler     06/27/06 - use new output functions 
#    jsmoler     11/23/05 - support 10.1.3 
#    jsmoler     10/04/04 - jsmoler_ecm01
#    jsmoler     08/26/04 - Creation
# 

use strict;
use ias::simpleXPath;
use ias::asecm;

my $oracleHome = $ARGV[0];
setOracleHome($oracleHome);
my $instanceName = $ARGV[1];

# Metric: PortRanges
setMetricFormat(
    { 'type' => 'string', 'key' => 1 }, # ID
    { 'type' => 'string' },             # range
);

my @results = simpleXPathQuery(
    "$oracleHome/opmn/conf/opmn.xml",
    'opmn//process-type[@module-id="OC4J"][@id="' . $instanceName . '"]/port'
);

my %protocolHash;
for my $result (@results)
{
    my $protocol = $$result{'protocol'};
    if (defined($protocol))
    {
        my $current = $protocolHash{$protocol};
        if (defined($current))
        {
            $current = $current . ',' . $$result{'range'}
        }
        else
        {
            $current = $$result{'range'};
        }
        $protocolHash{$protocol} = $current;
    }
    else
    {
        $protocolHash{$$result{'id'}} = $$result{'range'};
    }
}
for my $protocol (keys %protocolHash)
{
    printMetricResult(
        $protocol,
        $protocolHash{$protocol},
    );
}
